/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$DecoderState;
import org.apache.commons.compress.compressors.deflate64.HuffmanState;

class HuffmanDecoder$HuffmanCodes
extends HuffmanDecoder$DecoderState {
    private boolean endOfBlock;
    private final HuffmanState state;
    private final HuffmanDecoder.BinaryTreeNode lengthTree;
    private final HuffmanDecoder.BinaryTreeNode distanceTree;
    private int runBufferPos;
    private byte[] runBuffer;
    private int runBufferLength;
    final /* synthetic */ HuffmanDecoder this$0;

    HuffmanDecoder$HuffmanCodes(HuffmanDecoder huffmanDecoder, HuffmanState huffmanState, int[] nArray, int[] nArray2) {
        this.this$0 = huffmanDecoder;
        super(null);
        this.endOfBlock = false;
        this.runBufferPos = 0;
        this.runBuffer = new byte[0];
        this.runBufferLength = 0;
        this.state = huffmanState;
        this.lengthTree = HuffmanDecoder.access$800(nArray);
        this.distanceTree = HuffmanDecoder.access$800(nArray2);
    }

    @Override
    HuffmanState state() {
        return this.endOfBlock ? HuffmanState.INITIAL : this.state;
    }

    @Override
    int read(byte[] byArray, int n, int n2) {
        return this.decodeNext(byArray, n, n2);
    }

    private int decodeNext(byte[] byArray, int n, int n2) {
        if (this.endOfBlock) {
            return -1;
        }
        int n3 = this.copyFromRunBuffer(byArray, n, n2);
        while (n3 < n2) {
            int n4 = HuffmanDecoder.access$900(HuffmanDecoder.access$400(this.this$0), this.lengthTree);
            if (n4 < 256) {
                byArray[n + n3++] = HuffmanDecoder.access$600(this.this$0).add((byte)n4);
                continue;
            }
            if (n4 > 256) {
                short s = HuffmanDecoder.access$1000()[n4 - 257];
                int n5 = s >>> 5;
                int n6 = s & 0x1F;
                n5 = (int)((long)n5 + HuffmanDecoder.access$500(this.this$0, n6));
                int n7 = HuffmanDecoder.access$900(HuffmanDecoder.access$400(this.this$0), this.distanceTree);
                int n8 = HuffmanDecoder.access$1100()[n7];
                int n9 = n8 >>> 4;
                int n10 = n8 & 0xF;
                n9 = (int)((long)n9 + HuffmanDecoder.access$500(this.this$0, n10));
                if (this.runBuffer.length < n5) {
                    this.runBuffer = new byte[n5];
                }
                this.runBufferLength = n5;
                this.runBufferPos = 0;
                HuffmanDecoder.access$600(this.this$0).recordToBuffer(n9, n5, this.runBuffer);
                n3 += this.copyFromRunBuffer(byArray, n + n3, n2 - n3);
                continue;
            }
            this.endOfBlock = true;
            return n3;
        }
        return n3;
    }

    private int copyFromRunBuffer(byte[] byArray, int n, int n2) {
        int n3 = this.runBufferLength - this.runBufferPos;
        int n4 = 0;
        if (n3 > 0) {
            n4 = Math.min(n2, n3);
            System.arraycopy(this.runBuffer, this.runBufferPos, byArray, n, n4);
            this.runBufferPos += n4;
        }
        return n4;
    }

    @Override
    boolean hasData() {
        return !this.endOfBlock;
    }

    @Override
    int available() {
        return this.runBufferLength - this.runBufferPos;
    }
}

