/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$BinaryTreeNode;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$DecoderState;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$DecodingMemory;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$HuffmanCodes;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$InitialState;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$UncompressedState;
import org.apache.commons.compress.compressors.deflate64.HuffmanState;
import org.apache.commons.compress.utils.BitInputStream;

class HuffmanDecoder
implements Closeable {
    private static final short[] RUN_LENGTH_TABLE = new short[]{96, 128, 160, 192, 224, 256, 288, 320, 353, 417, 481, 545, 610, 738, 866, 994, 1123, 1379, 1635, 1891, 2148, 2660, 3172, 3684, 4197, 5221, 6245, 7269, 112};
    private static final int[] DISTANCE_TABLE = new int[]{16, 32, 48, 64, 81, 113, 146, 210, 275, 403, 532, 788, 1045, 1557, 2070, 3094, 4119, 6167, 8216, 12312, 16409, 24601, 32794, 49178, 65563, 98331, 131100, 196636, 262173, 393245, 524318, 786462};
    private static final int[] CODE_LENGTHS_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final int[] FIXED_LITERALS = new int[288];
    private static final int[] FIXED_DISTANCE;
    private boolean finalBlock = false;
    private HuffmanDecoder$DecoderState state;
    private BitInputStream reader;
    private final InputStream in;
    private final HuffmanDecoder$DecodingMemory memory = new HuffmanDecoder$DecodingMemory(null);

    HuffmanDecoder(InputStream inputStream) {
        this.reader = new BitInputStream(inputStream, ByteOrder.LITTLE_ENDIAN);
        this.in = inputStream;
        this.state = new HuffmanDecoder$InitialState(this);
    }

    @Override
    public void close() {
        this.state = new HuffmanDecoder$InitialState(this);
        this.reader = null;
    }

    public int decode(byte[] byArray) {
        return this.decode(byArray, 0, byArray.length);
    }

    public int decode(byte[] byArray, int n, int n2) {
        block5: while (!this.finalBlock || this.state.hasData()) {
            if (this.state.state() == HuffmanState.INITIAL) {
                this.finalBlock = this.readBits(1) == 1L;
                int n3 = (int)this.readBits(2);
                switch (n3) {
                    case 0: {
                        this.switchToUncompressedState();
                        continue block5;
                    }
                    case 1: {
                        this.state = new HuffmanDecoder$HuffmanCodes(this, HuffmanState.FIXED_CODES, FIXED_LITERALS, FIXED_DISTANCE);
                        continue block5;
                    }
                    case 2: {
                        int[][] nArray = this.readDynamicTables();
                        this.state = new HuffmanDecoder$HuffmanCodes(this, HuffmanState.DYNAMIC_CODES, nArray[0], nArray[1]);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unsupported compression: " + n3);
            }
            return this.state.read(byArray, n, n2);
        }
        return -1;
    }

    long getBytesRead() {
        return this.reader.getBytesRead();
    }

    private void switchToUncompressedState() {
        this.reader.alignWithByteBoundary();
        long l = this.readBits(16);
        long l2 = this.readBits(16);
        if (((l ^ 0xFFFFL) & 0xFFFFL) != l2) {
            throw new IllegalStateException("Illegal LEN / NLEN values");
        }
        this.state = new HuffmanDecoder$UncompressedState(this, l);
    }

    private int[][] readDynamicTables() {
        int[][] nArrayArray = new int[2][];
        int n = (int)(this.readBits(5) + 257L);
        nArrayArray[0] = new int[n];
        int n2 = (int)(this.readBits(5) + 1L);
        nArrayArray[1] = new int[n2];
        HuffmanDecoder.populateDynamicTables(this.reader, nArrayArray[0], nArrayArray[1]);
        return nArrayArray;
    }

    int available() {
        return this.state.available();
    }

    private static int nextSymbol(BitInputStream bitInputStream, HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode) {
        HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode2 = huffmanDecoder$BinaryTreeNode;
        while (huffmanDecoder$BinaryTreeNode2 != null && huffmanDecoder$BinaryTreeNode2.literal == -1) {
            long l = HuffmanDecoder.readBits(bitInputStream, 1);
            huffmanDecoder$BinaryTreeNode2 = l == 0L ? huffmanDecoder$BinaryTreeNode2.leftNode : huffmanDecoder$BinaryTreeNode2.rightNode;
        }
        return huffmanDecoder$BinaryTreeNode2 != null ? huffmanDecoder$BinaryTreeNode2.literal : -1;
    }

    private static void populateDynamicTables(BitInputStream bitInputStream, int[] nArray, int[] nArray2) {
        int n = (int)(HuffmanDecoder.readBits(bitInputStream, 4) + 4L);
        int[] nArray3 = new int[19];
        for (int i = 0; i < n; ++i) {
            nArray3[HuffmanDecoder.CODE_LENGTHS_ORDER[i]] = (int)HuffmanDecoder.readBits(bitInputStream, 3);
        }
        HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode = HuffmanDecoder.buildTree(nArray3);
        int[] nArray4 = new int[nArray.length + nArray2.length];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray4.length) {
            if (n3 > 0) {
                nArray4[n4++] = n2;
                --n3;
                continue;
            }
            int n5 = HuffmanDecoder.nextSymbol(bitInputStream, huffmanDecoder$BinaryTreeNode);
            if (n5 < 16) {
                n2 = n5;
                nArray4[n4++] = n2;
                continue;
            }
            if (n5 == 16) {
                n3 = (int)(HuffmanDecoder.readBits(bitInputStream, 2) + 3L);
                continue;
            }
            if (n5 == 17) {
                n2 = 0;
                n3 = (int)(HuffmanDecoder.readBits(bitInputStream, 3) + 3L);
                continue;
            }
            if (n5 != 18) continue;
            n2 = 0;
            n3 = (int)(HuffmanDecoder.readBits(bitInputStream, 7) + 11L);
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray.length);
        System.arraycopy(nArray4, nArray.length, nArray2, 0, nArray2.length);
    }

    private static HuffmanDecoder$BinaryTreeNode buildTree(int[] nArray) {
        int[] nArray2 = HuffmanDecoder.getCodes(nArray);
        HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode = new HuffmanDecoder$BinaryTreeNode(0, null);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == 0) continue;
            HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode2 = huffmanDecoder$BinaryTreeNode;
            int n2 = nArray2[n - 1];
            for (int j = n - 1; j >= 0; --j) {
                int n3 = n2 & 1 << j;
                huffmanDecoder$BinaryTreeNode2 = n3 == 0 ? huffmanDecoder$BinaryTreeNode2.left() : huffmanDecoder$BinaryTreeNode2.right();
            }
            huffmanDecoder$BinaryTreeNode2.leaf(i);
            int n4 = n - 1;
            nArray2[n4] = nArray2[n4] + 1;
        }
        return huffmanDecoder$BinaryTreeNode;
    }

    private static int[] getCodes(int[] nArray) {
        int n;
        int n2 = 0;
        int[] nArray2 = new int[65];
        int[] nArray3 = nArray;
        int n3 = nArray3.length;
        for (n = 0; n < n3; ++n) {
            int n4 = nArray3[n];
            n2 = Math.max(n2, n4);
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
        }
        nArray2 = Arrays.copyOf(nArray2, n2 + 1);
        int n6 = 0;
        int[] nArray4 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray4[n] = n6 = n6 + nArray2[n] << 1;
        }
        return nArray4;
    }

    private long readBits(int n) {
        return HuffmanDecoder.readBits(this.reader, n);
    }

    private static long readBits(BitInputStream bitInputStream, int n) {
        long l = bitInputStream.readBits(n);
        if (l == -1L) {
            throw new EOFException("Truncated Deflate64 Stream");
        }
        return l;
    }

    static /* synthetic */ BitInputStream access$400(HuffmanDecoder huffmanDecoder) {
        return huffmanDecoder.reader;
    }

    static /* synthetic */ long access$500(HuffmanDecoder huffmanDecoder, int n) {
        return huffmanDecoder.readBits(n);
    }

    static /* synthetic */ HuffmanDecoder$DecodingMemory access$600(HuffmanDecoder huffmanDecoder) {
        return huffmanDecoder.memory;
    }

    static /* synthetic */ InputStream access$700(HuffmanDecoder huffmanDecoder) {
        return huffmanDecoder.in;
    }

    static /* synthetic */ HuffmanDecoder$BinaryTreeNode access$800(int[] nArray) {
        return HuffmanDecoder.buildTree(nArray);
    }

    static /* synthetic */ int access$900(BitInputStream bitInputStream, HuffmanDecoder$BinaryTreeNode huffmanDecoder$BinaryTreeNode) {
        return HuffmanDecoder.nextSymbol(bitInputStream, huffmanDecoder$BinaryTreeNode);
    }

    static /* synthetic */ short[] access$1000() {
        return RUN_LENGTH_TABLE;
    }

    static /* synthetic */ int[] access$1100() {
        return DISTANCE_TABLE;
    }

    static {
        Arrays.fill(FIXED_LITERALS, 0, 144, 8);
        Arrays.fill(FIXED_LITERALS, 144, 256, 9);
        Arrays.fill(FIXED_LITERALS, 256, 280, 7);
        Arrays.fill(FIXED_LITERALS, 280, 288, 8);
        FIXED_DISTANCE = new int[32];
        Arrays.fill(FIXED_DISTANCE, 5);
    }
}

