/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$BackReference;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor$LiteralBlock;
import org.apache.commons.compress.utils.ByteUtils;

final class BlockLZ4CompressorOutputStream$Pair {
    private final Deque<byte[]> literals = new LinkedList<byte[]>();
    private int brOffset;
    private int brLength;
    private boolean written;

    BlockLZ4CompressorOutputStream$Pair() {
    }

    private void prependLiteral(byte[] byArray) {
        this.literals.addFirst(byArray);
    }

    byte[] addLiteral(LZ77Compressor$LiteralBlock lZ77Compressor$LiteralBlock) {
        byte[] byArray = Arrays.copyOfRange(lZ77Compressor$LiteralBlock.getData(), lZ77Compressor$LiteralBlock.getOffset(), lZ77Compressor$LiteralBlock.getOffset() + lZ77Compressor$LiteralBlock.getLength());
        this.literals.add(byArray);
        return byArray;
    }

    void setBackReference(LZ77Compressor$BackReference lZ77Compressor$BackReference) {
        if (this.hasBackReference()) {
            throw new IllegalStateException();
        }
        this.brOffset = lZ77Compressor$BackReference.getOffset();
        this.brLength = lZ77Compressor$BackReference.getLength();
    }

    boolean hasBackReference() {
        return this.brOffset > 0;
    }

    boolean canBeWritten(int n) {
        return this.hasBackReference() && n >= 16;
    }

    int length() {
        return this.literalLength() + this.brLength;
    }

    private boolean hasBeenWritten() {
        return this.written;
    }

    void writeTo(OutputStream outputStream) {
        int n = this.literalLength();
        outputStream.write(BlockLZ4CompressorOutputStream$Pair.lengths(n, this.brLength));
        if (n >= 15) {
            BlockLZ4CompressorOutputStream$Pair.writeLength(n - 15, outputStream);
        }
        for (byte[] byArray : this.literals) {
            outputStream.write(byArray);
        }
        if (this.hasBackReference()) {
            ByteUtils.toLittleEndian(outputStream, (long)this.brOffset, 2);
            if (this.brLength - 4 >= 15) {
                BlockLZ4CompressorOutputStream$Pair.writeLength(this.brLength - 4 - 15, outputStream);
            }
        }
        this.written = true;
    }

    private int literalLength() {
        int n = 0;
        for (byte[] byArray : this.literals) {
            n += byArray.length;
        }
        return n;
    }

    private static int lengths(int n, int n2) {
        int n3;
        int n4 = n3 = n < 15 ? n : 15;
        int n5 = n2 < 4 ? 0 : (n2 < 19 ? n2 - 4 : 15);
        return n3 << 4 | n5;
    }

    private static void writeLength(int n, OutputStream outputStream) {
        while (n >= 255) {
            outputStream.write(255);
            n -= 255;
        }
        outputStream.write(n);
    }

    private int backReferenceLength() {
        return this.brLength;
    }

    private void prependTo(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair) {
        Iterator<byte[]> iterator = this.literals.descendingIterator();
        while (iterator.hasNext()) {
            blockLZ4CompressorOutputStream$Pair.prependLiteral(iterator.next());
        }
    }

    private BlockLZ4CompressorOutputStream$Pair splitWithNewBackReferenceLengthOf(int n) {
        BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair = new BlockLZ4CompressorOutputStream$Pair();
        blockLZ4CompressorOutputStream$Pair.literals.addAll(this.literals);
        blockLZ4CompressorOutputStream$Pair.brOffset = this.brOffset;
        blockLZ4CompressorOutputStream$Pair.brLength = n;
        return blockLZ4CompressorOutputStream$Pair;
    }

    static /* synthetic */ boolean access$300(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair) {
        return blockLZ4CompressorOutputStream$Pair.hasBeenWritten();
    }

    static /* synthetic */ void access$400(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair, byte[] byArray) {
        blockLZ4CompressorOutputStream$Pair.prependLiteral(byArray);
    }

    static /* synthetic */ int access$500(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair) {
        return blockLZ4CompressorOutputStream$Pair.backReferenceLength();
    }

    static /* synthetic */ BlockLZ4CompressorOutputStream$Pair access$600(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair, int n) {
        return blockLZ4CompressorOutputStream$Pair.splitWithNewBackReferenceLengthOf(n);
    }

    static /* synthetic */ void access$700(BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair, BlockLZ4CompressorOutputStream$Pair blockLZ4CompressorOutputStream$Pair2) {
        blockLZ4CompressorOutputStream$Pair.prependTo(blockLZ4CompressorOutputStream$Pair2);
    }
}

