/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream$1;
import org.apache.commons.compress.utils.ByteUtils$ByteSupplier;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public abstract class AbstractLZ77CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final int windowSize;
    private final byte[] buf;
    private int writeIndex;
    private int readIndex;
    private final CountingInputStream in;
    private long bytesRemaining;
    private int backReferenceOffset;
    private int size = 0;
    private final byte[] oneByte = new byte[1];
    protected final ByteUtils$ByteSupplier supplier = new AbstractLZ77CompressorInputStream$1(this);

    public AbstractLZ77CompressorInputStream(InputStream inputStream, int n) {
        this.in = new CountingInputStream(inputStream);
        this.windowSize = n;
        this.buf = new byte[3 * n];
        this.readIndex = 0;
        this.writeIndex = 0;
        this.bytesRemaining = 0L;
    }

    @Override
    public int read() {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex;
    }

    public int getSize() {
        return this.size;
    }

    public void prefill(byte[] byArray) {
        if (this.writeIndex != 0) {
            throw new IllegalStateException("the stream has already been read from, can't prefill anymore");
        }
        int n = Math.min(this.windowSize, byArray.length);
        System.arraycopy(byArray, byArray.length - n, this.buf, 0, n);
        this.writeIndex += n;
        this.readIndex += n;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    protected final void startLiteral(long l) {
        this.bytesRemaining = l;
    }

    protected final boolean hasMoreDataInBlock() {
        return this.bytesRemaining > 0L;
    }

    protected final int readLiteral(byte[] byArray, int n, int n2) {
        int n3 = this.available();
        if (n2 > n3) {
            this.tryToReadLiteral(n2 - n3);
        }
        return this.readFromBuffer(byArray, n, n2);
    }

    private void tryToReadLiteral(int n) {
        int n2 = Math.min((int)Math.min((long)n, this.bytesRemaining), this.buf.length - this.writeIndex);
        int n3 = n2 > 0 ? IOUtils.readFully(this.in, this.buf, this.writeIndex, n2) : 0;
        this.count(n3);
        if (n2 != n3) {
            throw new IOException("Premature end of stream reading literal");
        }
        this.writeIndex += n2;
        this.bytesRemaining -= (long)n2;
    }

    private int readFromBuffer(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.available());
        if (n3 > 0) {
            System.arraycopy(this.buf, this.readIndex, byArray, n, n3);
            this.readIndex += n3;
            if (this.readIndex > 2 * this.windowSize) {
                this.slideBuffer();
            }
        }
        this.size += n3;
        return n3;
    }

    private void slideBuffer() {
        System.arraycopy(this.buf, this.windowSize, this.buf, 0, this.windowSize * 2);
        this.writeIndex -= this.windowSize;
        this.readIndex -= this.windowSize;
    }

    protected final void startBackReference(int n, long l) {
        this.backReferenceOffset = n;
        this.bytesRemaining = l;
    }

    protected final int readBackReference(byte[] byArray, int n, int n2) {
        int n3 = this.available();
        if (n2 > n3) {
            this.tryToCopy(n2 - n3);
        }
        return this.readFromBuffer(byArray, n, n2);
    }

    private void tryToCopy(int n) {
        int n2 = Math.min((int)Math.min((long)n, this.bytesRemaining), this.buf.length - this.writeIndex);
        if (n2 != 0) {
            if (this.backReferenceOffset == 1) {
                byte by = this.buf[this.writeIndex - 1];
                Arrays.fill(this.buf, this.writeIndex, this.writeIndex + n2, by);
                this.writeIndex += n2;
            } else if (n2 < this.backReferenceOffset) {
                System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, n2);
                this.writeIndex += n2;
            } else {
                int n3;
                int n4 = n2 / this.backReferenceOffset;
                for (n3 = 0; n3 < n4; ++n3) {
                    System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, this.backReferenceOffset);
                    this.writeIndex += this.backReferenceOffset;
                }
                n3 = n2 - this.backReferenceOffset * n4;
                if (n3 > 0) {
                    System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, n3);
                    this.writeIndex += n3;
                }
            }
        }
        this.bytesRemaining -= (long)n2;
    }

    protected final int readOneByte() {
        int n = this.in.read();
        if (n != -1) {
            this.count(1);
            return n & 0xFF;
        }
        return -1;
    }
}

