/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzw;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.BitInputStream;
import org.apache.commons.compress.utils.InputStreamStatistics;

public abstract class LZWInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    protected static final int DEFAULT_CODE_SIZE = 9;
    protected static final int UNUSED_PREFIX = -1;
    private final byte[] oneByte = new byte[1];
    protected final BitInputStream in;
    private int clearCode = -1;
    private int codeSize = 9;
    private byte previousCodeFirstChar;
    private int previousCode = -1;
    private int tableSize;
    private int[] prefixes;
    private byte[] characters;
    private byte[] outputStack;
    private int outputStackLocation;

    protected LZWInputStream(InputStream inputStream, ByteOrder byteOrder) {
        this.in = new BitInputStream(inputStream, byteOrder);
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public int read() {
        int n = this.read(this.oneByte);
        if (n < 0) {
            return n;
        }
        return 0xFF & this.oneByte[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.readFromStack(byArray, n, n2);
        while (n2 - n3 > 0) {
            int n4 = this.decompressNextSymbol();
            if (n4 < 0) {
                if (n3 > 0) {
                    this.count(n3);
                    return n3;
                }
                return n4;
            }
            n3 += this.readFromStack(byArray, n + n3, n2 - n3);
        }
        this.count(n3);
        return n3;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    protected abstract int decompressNextSymbol();

    protected abstract int addEntry(int var1, byte var2);

    protected void setClearCode(int n) {
        this.clearCode = 1 << n - 1;
    }

    protected void initializeTables(int n, int n2) {
        int n3;
        long l;
        long l2;
        if (n2 > -1 && (l2 = (l = (long)(n3 = 1 << n) * 6L) >> 10) > (long)n2) {
            throw new MemoryLimitException(l2, n2);
        }
        this.initializeTables(n);
    }

    protected void initializeTables(int n) {
        int n2 = 1 << n;
        this.prefixes = new int[n2];
        this.characters = new byte[n2];
        this.outputStack = new byte[n2];
        this.outputStackLocation = n2;
        int n3 = 256;
        for (int i = 0; i < 256; ++i) {
            this.prefixes[i] = -1;
            this.characters[i] = (byte)i;
        }
    }

    protected int readNextCode() {
        if (this.codeSize > 31) {
            throw new IllegalArgumentException("code size must not be bigger than 31");
        }
        return (int)this.in.readBits(this.codeSize);
    }

    protected int addEntry(int n, byte by, int n2) {
        if (this.tableSize < n2) {
            this.prefixes[this.tableSize] = n;
            this.characters[this.tableSize] = by;
            return this.tableSize++;
        }
        return -1;
    }

    protected int addRepeatOfPreviousCode() {
        if (this.previousCode == -1) {
            throw new IOException("The first code can't be a reference to its preceding code");
        }
        return this.addEntry(this.previousCode, this.previousCodeFirstChar);
    }

    protected int expandCodeToOutputStack(int n, boolean bl) {
        int n2 = n;
        while (n2 >= 0) {
            this.outputStack[--this.outputStackLocation] = this.characters[n2];
            n2 = this.prefixes[n2];
        }
        if (this.previousCode != -1 && !bl) {
            this.addEntry(this.previousCode, this.outputStack[this.outputStackLocation]);
        }
        this.previousCode = n;
        this.previousCodeFirstChar = this.outputStack[this.outputStackLocation];
        return this.outputStackLocation;
    }

    private int readFromStack(byte[] byArray, int n, int n2) {
        int n3 = this.outputStack.length - this.outputStackLocation;
        if (n3 > 0) {
            int n4 = Math.min(n3, n2);
            System.arraycopy(this.outputStack, this.outputStackLocation, byArray, n, n4);
            this.outputStackLocation += n4;
            return n4;
        }
        return 0;
    }

    protected int getCodeSize() {
        return this.codeSize;
    }

    protected void resetCodeSize() {
        this.setCodeSize(9);
    }

    protected void setCodeSize(int n) {
        this.codeSize = n;
    }

    protected void incrementCodeSize() {
        ++this.codeSize;
    }

    protected void resetPreviousCode() {
        this.previousCode = -1;
    }

    protected int getPrefix(int n) {
        return this.prefixes[n];
    }

    protected void setPrefix(int n, int n2) {
        this.prefixes[n] = n2;
    }

    protected int getPrefixesLength() {
        return this.prefixes.length;
    }

    protected int getClearCode() {
        return this.clearCode;
    }

    protected int getTableSize() {
        return this.tableSize;
    }

    protected void setTableSize(int n) {
        this.tableSize = n;
    }
}

