/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.PureJavaCrc32C;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.ByteUtils$ByteConsumer;
import org.apache.commons.compress.utils.ByteUtils$OutputStreamByteConsumer;

public class FramedSnappyCompressorOutputStream
extends CompressorOutputStream {
    private static final int MAX_COMPRESSED_BUFFER_SIZE = 65536;
    private final OutputStream out;
    private final Parameters params;
    private final PureJavaCrc32C checksum = new PureJavaCrc32C();
    private final byte[] oneByte = new byte[1];
    private final byte[] buffer = new byte[65536];
    private int currentIndex = 0;
    private final ByteUtils$ByteConsumer consumer;

    public FramedSnappyCompressorOutputStream(OutputStream outputStream) {
        this(outputStream, SnappyCompressorOutputStream.createParameterBuilder(32768).build());
    }

    public FramedSnappyCompressorOutputStream(OutputStream outputStream, Parameters parameters) {
        this.out = outputStream;
        this.params = parameters;
        this.consumer = new ByteUtils$OutputStreamByteConsumer(outputStream);
        outputStream.write(FramedSnappyCompressorInputStream.SZ_SIGNATURE);
    }

    @Override
    public void write(int n) {
        this.oneByte[0] = (byte)(n & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this.currentIndex + n2 > 65536) {
            this.flushBuffer();
            while (n2 > 65536) {
                System.arraycopy(byArray, n, this.buffer, 0, 65536);
                n += 65536;
                n2 -= 65536;
                this.currentIndex = 65536;
                this.flushBuffer();
            }
        }
        System.arraycopy(byArray, n, this.buffer, this.currentIndex, n2);
        this.currentIndex += n2;
    }

    @Override
    public void close() {
        this.finish();
        this.out.close();
    }

    public void finish() {
        if (this.currentIndex > 0) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        this.out.write(0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Object object = new SnappyCompressorOutputStream((OutputStream)byteArrayOutputStream, (long)this.currentIndex, this.params);){
            ((OutputStream)object).write(this.buffer, 0, this.currentIndex);
        }
        object = byteArrayOutputStream.toByteArray();
        this.writeLittleEndian(3, (long)((Object)object).length + 4L);
        this.writeCrc();
        this.out.write((byte[])object);
        this.currentIndex = 0;
    }

    private void writeLittleEndian(int n, long l) {
        ByteUtils.toLittleEndian(this.consumer, l, n);
    }

    private void writeCrc() {
        this.checksum.update(this.buffer, 0, this.currentIndex);
        this.writeLittleEndian(4, FramedSnappyCompressorOutputStream.mask(this.checksum.getValue()));
        this.checksum.reset();
    }

    static long mask(long l) {
        l = l >> 15 | l << 17;
        l += 2726488792L;
        return l &= 0xFFFFFFFFL;
    }
}

