/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import org.apache.commons.compress.compressors.zstandard.ZstdUtils$CachedAvailability;

public class ZstdUtils {
    private static final byte[] ZSTANDARD_FRAME_MAGIC = new byte[]{40, -75, 47, -3};
    private static final byte[] SKIPPABLE_FRAME_MAGIC = new byte[]{42, 77, 24};
    private static volatile ZstdUtils$CachedAvailability cachedZstdAvailability = ZstdUtils$CachedAvailability.DONT_CACHE;

    private ZstdUtils() {
    }

    public static boolean isZstdCompressionAvailable() {
        ZstdUtils$CachedAvailability zstdUtils$CachedAvailability = cachedZstdAvailability;
        if (zstdUtils$CachedAvailability != ZstdUtils$CachedAvailability.DONT_CACHE) {
            return zstdUtils$CachedAvailability == ZstdUtils$CachedAvailability.CACHED_AVAILABLE;
        }
        return ZstdUtils.internalIsZstdCompressionAvailable();
    }

    private static boolean internalIsZstdCompressionAvailable() {
        try {
            Class.forName("com.github.luben.zstd.ZstdInputStream");
            return true;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return false;
        }
    }

    public static void setCacheZstdAvailablity(boolean bl) {
        if (!bl) {
            cachedZstdAvailability = ZstdUtils$CachedAvailability.DONT_CACHE;
        } else if (cachedZstdAvailability == ZstdUtils$CachedAvailability.DONT_CACHE) {
            boolean bl2 = ZstdUtils.internalIsZstdCompressionAvailable();
            cachedZstdAvailability = bl2 ? ZstdUtils$CachedAvailability.CACHED_AVAILABLE : ZstdUtils$CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    public static boolean matches(byte[] byArray, int n) {
        int n2;
        if (n < ZSTANDARD_FRAME_MAGIC.length) {
            return false;
        }
        boolean bl = true;
        for (n2 = 0; n2 < ZSTANDARD_FRAME_MAGIC.length; ++n2) {
            if (byArray[n2] == ZSTANDARD_FRAME_MAGIC[n2]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        if (80 == (byArray[0] & 0xF0)) {
            for (n2 = 0; n2 < SKIPPABLE_FRAME_MAGIC.length; ++n2) {
                if (byArray[n2 + 1] == SKIPPABLE_FRAME_MAGIC[n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static ZstdUtils$CachedAvailability getCachedZstdAvailability() {
        return cachedZstdAvailability;
    }

    static {
        try {
            Class.forName("org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            ZstdUtils.setCacheZstdAvailablity(true);
        }
    }
}

