/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.parallel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;

public class FileBasedScatterGatherBackingStore
implements ScatterGatherBackingStore {
    private final File target;
    private final OutputStream os;
    private boolean closed;

    public FileBasedScatterGatherBackingStore(File file) {
        this.target = file;
        try {
            this.os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public InputStream getInputStream() {
        return Files.newInputStream(this.target.toPath(), new OpenOption[0]);
    }

    @Override
    public void closeForWriting() {
        if (!this.closed) {
            this.os.close();
            this.closed = true;
        }
    }

    @Override
    public void writeOut(byte[] byArray, int n, int n2) {
        this.os.write(byArray, n, n2);
    }

    @Override
    public void close() {
        this.closeForWriting();
        this.target.delete();
    }
}

