/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.utils.CountingInputStream;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 63;
    private static final long[] MASKS = new long[64];
    private final CountingInputStream in;
    private final ByteOrder byteOrder;
    private long bitsCached = 0L;
    private int bitsCachedSize = 0;

    public BitInputStream(InputStream inputStream, ByteOrder byteOrder) {
        this.in = new CountingInputStream(inputStream);
        this.byteOrder = byteOrder;
    }

    @Override
    public void close() {
        this.in.close();
    }

    public void clearBitCache() {
        this.bitsCached = 0L;
        this.bitsCachedSize = 0;
    }

    public long readBits(int n) {
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException("count must not be negative or greater than 63");
        }
        if (this.ensureCache(n)) {
            return -1L;
        }
        if (this.bitsCachedSize < n) {
            return this.processBitsGreater57(n);
        }
        return this.readCachedBits(n);
    }

    public int bitsCached() {
        return this.bitsCachedSize;
    }

    public long bitsAvailable() {
        return (long)this.bitsCachedSize + 8L * (long)this.in.available();
    }

    public void alignWithByteBoundary() {
        int n = this.bitsCachedSize % 8;
        if (n > 0) {
            this.readCachedBits(n);
        }
    }

    public long getBytesRead() {
        return this.in.getBytesRead();
    }

    private long processBitsGreater57(int n) {
        int n2 = 0;
        long l = 0L;
        int n3 = n - this.bitsCachedSize;
        n2 = 8 - n3;
        long l2 = this.in.read();
        if (l2 < 0L) {
            return l2;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            long l3 = l2 & MASKS[n3];
            this.bitsCached |= l3 << this.bitsCachedSize;
            l = l2 >>> n3 & MASKS[n2];
        } else {
            this.bitsCached <<= n3;
            long l4 = l2 >>> n2 & MASKS[n3];
            this.bitsCached |= l4;
            l = l2 & MASKS[n2];
        }
        long l5 = this.bitsCached & MASKS[n];
        this.bitsCached = l;
        this.bitsCachedSize = n2;
        return l5;
    }

    private long readCachedBits(int n) {
        long l;
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            l = this.bitsCached & MASKS[n];
            this.bitsCached >>>= n;
        } else {
            l = this.bitsCached >> this.bitsCachedSize - n & MASKS[n];
        }
        this.bitsCachedSize -= n;
        return l;
    }

    private boolean ensureCache(int n) {
        while (this.bitsCachedSize < n && this.bitsCachedSize < 57) {
            long l = this.in.read();
            if (l < 0L) {
                return true;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= l << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= l;
            }
            this.bitsCachedSize += 8;
        }
        return false;
    }

    static {
        for (int i = 1; i <= 63; ++i) {
            BitInputStream.MASKS[i] = (MASKS[i - 1] << 1) + 1L;
        }
    }
}

