/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;

class FixedLengthBlockOutputStream$BufferAtATimeOutputChannel
implements WritableByteChannel {
    private final OutputStream out;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private FixedLengthBlockOutputStream$BufferAtATimeOutputChannel(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!byteBuffer.hasArray()) {
            throw new IllegalArgumentException("direct buffer somehow written to BufferAtATimeOutputChannel");
        }
        try {
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit() - n;
            this.out.write(byteBuffer.array(), byteBuffer.arrayOffset() + n, n2);
            byteBuffer.position(byteBuffer.limit());
            return n2;
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.out.close();
        }
    }
}

