/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.utils.FixedLengthBlockOutputStream$BufferAtATimeOutputChannel;

public class FixedLengthBlockOutputStream
extends OutputStream
implements WritableByteChannel {
    private final WritableByteChannel out;
    private final int blockSize;
    private final ByteBuffer buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public FixedLengthBlockOutputStream(OutputStream outputStream, int n) {
        if (outputStream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
            this.out = fileOutputStream.getChannel();
            this.buffer = ByteBuffer.allocateDirect(n);
        } else {
            this.out = new FixedLengthBlockOutputStream$BufferAtATimeOutputChannel(outputStream, null);
            this.buffer = ByteBuffer.allocate(n);
        }
        this.blockSize = n;
    }

    public FixedLengthBlockOutputStream(WritableByteChannel writableByteChannel, int n) {
        this.out = writableByteChannel;
        this.blockSize = n;
        this.buffer = ByteBuffer.allocateDirect(n);
    }

    private void maybeFlush() {
        if (!this.buffer.hasRemaining()) {
            this.writeBlock();
        }
    }

    private void writeBlock() {
        this.buffer.flip();
        int n = this.out.write(this.buffer);
        boolean bl = this.buffer.hasRemaining();
        if (n != this.blockSize || bl) {
            String string = String.format("Failed to write %,d bytes atomically. Only wrote  %,d", this.blockSize, n);
            throw new IOException(string);
        }
        this.buffer.clear();
    }

    @Override
    public void write(int n) {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.buffer.put((byte)n);
        this.maybeFlush();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = Math.min(n4, this.buffer.remaining());
            this.buffer.put(byArray, n3, n5);
            this.maybeFlush();
            n4 -= n5;
            n3 += n5;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int n = byteBuffer.remaining();
        if (n < this.buffer.remaining()) {
            this.buffer.put(byteBuffer);
        } else {
            int n2 = n;
            int n3 = byteBuffer.limit();
            if (this.buffer.position() != 0) {
                int n4 = this.buffer.remaining();
                byteBuffer.limit(byteBuffer.position() + n4);
                this.buffer.put(byteBuffer);
                this.writeBlock();
                n2 -= n4;
            }
            while (n2 >= this.blockSize) {
                byteBuffer.limit(byteBuffer.position() + this.blockSize);
                this.out.write(byteBuffer);
                n2 -= this.blockSize;
            }
            byteBuffer.limit(n3);
            this.buffer.put(byteBuffer);
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        if (!this.out.isOpen()) {
            this.closed.set(true);
        }
        return !this.closed.get();
    }

    public void flushBlock() {
        if (this.buffer.position() != 0) {
            this.padBlock();
            this.writeBlock();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.flushBlock();
            this.out.close();
        }
    }

    private void padBlock() {
        this.buffer.order(ByteOrder.nativeOrder());
        int n = this.buffer.remaining();
        if (n > 8) {
            int n2 = this.buffer.position() & 7;
            if (n2 != 0) {
                int n3 = 8 - n2;
                for (int i = 0; i < n3; ++i) {
                    this.buffer.put((byte)0);
                }
                n -= n3;
            }
            while (n >= 8) {
                this.buffer.putLong(0L);
                n -= 8;
            }
        }
        while (this.buffer.hasRemaining()) {
            this.buffer.put((byte)0);
        }
    }
}

