/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.ObservableInputStream$Observer;
import org.apache.commons.io.input.ProxyInputStream;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<ObservableInputStream$Observer> observers = new ArrayList<ObservableInputStream$Observer>();

    public ObservableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void add(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.add(observableInputStream$Observer);
    }

    public void remove(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.remove(observableInputStream$Observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    @Override
    public int read() {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n == -1) {
            this.noteFinished();
        } else if (n > 0) {
            this.noteDataBytes(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        IOException iOException = null;
        try {
            n3 = super.read(byArray, n, n2);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n3 == -1) {
            this.noteFinished();
        } else if (n3 > 0) {
            this.noteDataBytes(byArray, n, n3);
        }
        return n3;
    }

    protected void noteDataBytes(byte[] byArray, int n, int n2) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.data(byArray, n, n2);
        }
    }

    protected void noteFinished() {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.finished();
        }
    }

    protected void noteDataByte(int n) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.data(n);
        }
    }

    protected void noteError(IOException iOException) {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.error(iOException);
        }
    }

    protected void noteClosed() {
        for (ObservableInputStream$Observer observableInputStream$Observer : this.getObservers()) {
            observableInputStream$Observer.closed();
        }
    }

    protected List<ObservableInputStream$Observer> getObservers() {
        return this.observers;
    }

    @Override
    public void close() {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
        } else {
            this.noteError(iOException);
        }
    }

    public void consume() {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = this.read(byArray)) != -1) {
        }
    }
}

