/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;
    private final String prefix;
    private final String suffix;
    private final File directory;
    private boolean closed = false;

    public DeferredFileOutputStream(int n, File file) {
        this(n, file, null, null, null, 1024);
    }

    public DeferredFileOutputStream(int n, int n2, File file) {
        this(n, file, null, null, null, n2);
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    public DeferredFileOutputStream(int n, String string, String string2, File file) {
        this(n, null, string, string2, file, 1024);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    public DeferredFileOutputStream(int n, int n2, String string, String string2, File file) {
        this(n, null, string, string2, file, n2);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    private DeferredFileOutputStream(int n, File file, String string, String string2, File file2, int n2) {
        super(n);
        this.outputFile = file;
        this.prefix = string;
        this.suffix = string2;
        this.directory = file2;
        this.memoryOutputStream = new ByteArrayOutputStream(n2);
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Override
    protected OutputStream getStream() {
        return this.currentOutputStream;
    }

    @Override
    protected void thresholdReached() {
        if (this.prefix != null) {
            this.outputFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        }
        FileUtils.forceMkdirParent(this.outputFile);
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
        try {
            this.memoryOutputStream.writeTo(fileOutputStream);
        }
        catch (IOException iOException) {
            fileOutputStream.close();
            throw iOException;
        }
        this.currentOutputStream = fileOutputStream;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    @Override
    public void close() {
        super.close();
        this.closed = true;
    }

    public void writeTo(OutputStream outputStream) {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(outputStream);
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(this.outputFile);){
                IOUtils.copy((InputStream)fileInputStream, outputStream);
            }
        }
    }
}

