/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ThreadUtils$AlwaysTruePredicate;
import org.apache.commons.lang3.ThreadUtils$NamePredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadGroupPredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadIdPredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadPredicate;
import org.apache.commons.lang3.Validate;

public class ThreadUtils {
    public static final ThreadUtils$AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new ThreadUtils$AlwaysTruePredicate();

    public static Thread findThreadById(long l, ThreadGroup threadGroup) {
        Validate.isTrue(threadGroup != null, "The thread group must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l, String string) {
        Validate.isTrue(string != null, "The thread group name must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, new ThreadUtils$NamePredicate(string));
    }

    public static Collection<Thread> findThreadsByName(String string, String string2) {
        Validate.isTrue(string != null, "The thread name must not be null", new Object[0]);
        Validate.isTrue(string2 != null, "The thread group name must not be null", new Object[0]);
        Collection<ThreadGroup> collection = ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate(string2));
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        ThreadUtils$NamePredicate threadUtils$NamePredicate = new ThreadUtils$NamePredicate(string);
        for (ThreadGroup threadGroup : collection) {
            arrayList.addAll(ThreadUtils.findThreads(threadGroup, false, threadUtils$NamePredicate));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(new ThreadUtils$NamePredicate(string));
    }

    public static Thread findThreadById(long l) {
        Collection<Thread> collection = ThreadUtils.findThreads(new ThreadUtils$ThreadIdPredicate(l));
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static Collection<Thread> findThreads(ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadGroupPredicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl, ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        Thread[] threadArray;
        Validate.isTrue(threadGroup != null, "The group must not be null", new Object[0]);
        Validate.isTrue(threadUtils$ThreadPredicate != null, "The predicate must not be null", new Object[0]);
        int n = threadGroup.activeCount();
        while ((n = threadGroup.enumerate(threadArray = new Thread[n + n / 2 + 1], bl)) >= threadArray.length) {
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>(n);
        for (int i = 0; i < n; ++i) {
            if (!threadUtils$ThreadPredicate.test(threadArray[i])) continue;
            arrayList.add(threadArray[i]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl, ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        ThreadGroup[] threadGroupArray;
        Validate.isTrue(threadGroup != null, "The group must not be null", new Object[0]);
        Validate.isTrue(threadUtils$ThreadGroupPredicate != null, "The predicate must not be null", new Object[0]);
        int n = threadGroup.activeGroupCount();
        while ((n = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n + n / 2 + 1], bl)) >= threadGroupArray.length) {
        }
        ArrayList<ThreadGroup> arrayList = new ArrayList<ThreadGroup>(n);
        for (int i = 0; i < n; ++i) {
            if (!threadUtils$ThreadGroupPredicate.test(threadGroupArray[i])) continue;
            arrayList.add(threadGroupArray[i]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

