/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.concurrent.BasicThreadFactory$Builder;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong threadCounter;
    private final ThreadFactory wrappedFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String namingPattern;
    private final Integer priority;
    private final Boolean daemonFlag;

    private BasicThreadFactory(BasicThreadFactory$Builder basicThreadFactory$Builder) {
        this.wrappedFactory = BasicThreadFactory$Builder.access$000(basicThreadFactory$Builder) == null ? Executors.defaultThreadFactory() : BasicThreadFactory$Builder.access$000(basicThreadFactory$Builder);
        this.namingPattern = BasicThreadFactory$Builder.access$100(basicThreadFactory$Builder);
        this.priority = BasicThreadFactory$Builder.access$200(basicThreadFactory$Builder);
        this.daemonFlag = BasicThreadFactory$Builder.access$300(basicThreadFactory$Builder);
        this.uncaughtExceptionHandler = BasicThreadFactory$Builder.access$400(basicThreadFactory$Builder);
        this.threadCounter = new AtomicLong();
    }

    public final ThreadFactory getWrappedFactory() {
        return this.wrappedFactory;
    }

    public final String getNamingPattern() {
        return this.namingPattern;
    }

    public final Boolean getDaemonFlag() {
        return this.daemonFlag;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public long getThreadCount() {
        return this.threadCounter.get();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.getWrappedFactory().newThread(runnable);
        this.initializeThread(thread);
        return thread;
    }

    private void initializeThread(Thread thread) {
        if (this.getNamingPattern() != null) {
            Long l = this.threadCounter.incrementAndGet();
            thread.setName(String.format(this.getNamingPattern(), l));
        }
        if (this.getUncaughtExceptionHandler() != null) {
            thread.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        }
        if (this.getPriority() != null) {
            thread.setPriority(this.getPriority());
        }
        if (this.getDaemonFlag() != null) {
            thread.setDaemon(this.getDaemonFlag());
        }
    }
}

