/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DatePrinter;
import org.apache.commons.lang3.time.FastDatePrinter$CharacterLiteral;
import org.apache.commons.lang3.time.FastDatePrinter$DayInWeekField;
import org.apache.commons.lang3.time.FastDatePrinter$Iso8601_Rule;
import org.apache.commons.lang3.time.FastDatePrinter$NumberRule;
import org.apache.commons.lang3.time.FastDatePrinter$PaddedNumberField;
import org.apache.commons.lang3.time.FastDatePrinter$Rule;
import org.apache.commons.lang3.time.FastDatePrinter$StringLiteral;
import org.apache.commons.lang3.time.FastDatePrinter$TextField;
import org.apache.commons.lang3.time.FastDatePrinter$TimeZoneDisplayKey;
import org.apache.commons.lang3.time.FastDatePrinter$TimeZoneNameRule;
import org.apache.commons.lang3.time.FastDatePrinter$TimeZoneNumberRule;
import org.apache.commons.lang3.time.FastDatePrinter$TwelveHourField;
import org.apache.commons.lang3.time.FastDatePrinter$TwentyFourHourField;
import org.apache.commons.lang3.time.FastDatePrinter$TwoDigitMonthField;
import org.apache.commons.lang3.time.FastDatePrinter$TwoDigitNumberField;
import org.apache.commons.lang3.time.FastDatePrinter$TwoDigitYearField;
import org.apache.commons.lang3.time.FastDatePrinter$UnpaddedMonthField;
import org.apache.commons.lang3.time.FastDatePrinter$UnpaddedNumberField;
import org.apache.commons.lang3.time.FastDatePrinter$WeekYear;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDatePrinter$Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<FastDatePrinter$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDatePrinter$TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDatePrinter$Rule> list = this.parsePattern();
        this.mRules = list.toArray(new FastDatePrinter$Rule[list.size()]);
        int n = 0;
        int n2 = this.mRules.length;
        while (--n2 >= 0) {
            n += this.mRules[n2].estimateLength();
        }
        this.mMaxLengthEstimate = n;
    }

    protected List<FastDatePrinter$Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDatePrinter$Rule> arrayList = new ArrayList<FastDatePrinter$Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            FastDatePrinter$Rule fastDatePrinter$Rule;
            nArray[0] = i;
            String string = this.parseToken(this.mPattern, nArray);
            i = nArray[0];
            int n2 = string.length();
            if (n2 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(0, stringArray);
                    break;
                }
                case 'Y': 
                case 'y': {
                    fastDatePrinter$Rule = n2 == 2 ? FastDatePrinter$TwoDigitYearField.INSTANCE : this.selectNumberRule(1, n2 < 4 ? 4 : n2);
                    if (c2 != 'Y') break;
                    fastDatePrinter$Rule = new FastDatePrinter$WeekYear((FastDatePrinter$NumberRule)fastDatePrinter$Rule);
                    break;
                }
                case 'M': {
                    if (n2 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray2);
                        break;
                    }
                    if (n2 == 3) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray3);
                        break;
                    }
                    if (n2 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    fastDatePrinter$Rule = this.selectNumberRule(5, n2);
                    break;
                }
                case 'h': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, n2));
                    break;
                }
                case 'H': {
                    fastDatePrinter$Rule = this.selectNumberRule(11, n2);
                    break;
                }
                case 'm': {
                    fastDatePrinter$Rule = this.selectNumberRule(12, n2);
                    break;
                }
                case 's': {
                    fastDatePrinter$Rule = this.selectNumberRule(13, n2);
                    break;
                }
                case 'S': {
                    fastDatePrinter$Rule = this.selectNumberRule(14, n2);
                    break;
                }
                case 'E': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(7, n2 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'u': {
                    fastDatePrinter$Rule = new FastDatePrinter$DayInWeekField(this.selectNumberRule(7, n2));
                    break;
                }
                case 'D': {
                    fastDatePrinter$Rule = this.selectNumberRule(6, n2);
                    break;
                }
                case 'F': {
                    fastDatePrinter$Rule = this.selectNumberRule(8, n2);
                    break;
                }
                case 'w': {
                    fastDatePrinter$Rule = this.selectNumberRule(3, n2);
                    break;
                }
                case 'W': {
                    fastDatePrinter$Rule = this.selectNumberRule(4, n2);
                    break;
                }
                case 'a': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, n2));
                    break;
                }
                case 'K': {
                    fastDatePrinter$Rule = this.selectNumberRule(10, n2);
                    break;
                }
                case 'X': {
                    fastDatePrinter$Rule = FastDatePrinter$Iso8601_Rule.getRule(n2);
                    break;
                }
                case 'z': {
                    if (n2 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n2 == 1) {
                        fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n2 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        fastDatePrinter$Rule = new FastDatePrinter$CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add(fastDatePrinter$Rule);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        char c2 = string.charAt(n);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n + 1 < n2 && (c3 = string.charAt(n + 1)) == c2) {
                stringBuilder.append(c2);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c2 = string.charAt(n);
                if (c2 == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuilder.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int n, int n2) {
        switch (n2) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(n);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(n);
            }
        }
        return new FastDatePrinter$PaddedNumberField(n, n2);
    }

    @Override
    @Deprecated
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((long)((Long)object), stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    @Override
    public String format(long l) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l);
        return this.applyRulesToString(calendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.mTimeZone, this.mLocale);
    }

    @Override
    public String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.format(calendar.getTime(), stringBuffer);
    }

    @Override
    public <B extends Appendable> B format(long l, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l);
        return this.applyRules(calendar, b2);
    }

    @Override
    public <B extends Appendable> B format(Date date, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, b2);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B b2) {
        if (!calendar.getTimeZone().equals(this.mTimeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, b2);
    }

    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B b2) {
        try {
            for (FastDatePrinter$Rule fastDatePrinter$Rule : this.mRules) {
                fastDatePrinter$Rule.appendTo(b2, calendar);
            }
        }
        catch (IOException iOException) {
            ExceptionUtils.rethrow(iOException);
        }
        return b2;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter fastDatePrinter = (FastDatePrinter)object;
        return this.mPattern.equals(fastDatePrinter.mPattern) && this.mTimeZone.equals(fastDatePrinter.mTimeZone) && this.mLocale.equals(fastDatePrinter.mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(Appendable appendable, int n) {
        appendable.append((char)(n / 10 + 48));
        appendable.append((char)(n % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n, int n2) {
        if (n < 10000) {
            int n3 = 4;
            if (n < 1000) {
                --n3;
                if (n < 100) {
                    --n3;
                    if (n < 10) {
                        --n3;
                    }
                }
            }
            for (int i = n2 - n3; i > 0; --i) {
                appendable.append('0');
            }
            switch (n3) {
                case 4: {
                    appendable.append((char)(n / 1000 + 48));
                    n %= 1000;
                }
                case 3: {
                    if (n >= 100) {
                        appendable.append((char)(n / 100 + 48));
                        n %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n >= 10) {
                        appendable.append((char)(n / 10 + 48));
                        n %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n + 48));
                }
            }
        } else {
            char[] cArray = new char[10];
            int n4 = 0;
            while (n != 0) {
                cArray[n4++] = (char)(n % 10 + 48);
                n /= 10;
            }
            while (n4 < n2) {
                appendable.append('0');
                --n2;
            }
            while (--n4 >= 0) {
                appendable.append(cArray[n4]);
            }
        }
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl, int n, Locale locale) {
        String string;
        FastDatePrinter$TimeZoneDisplayKey fastDatePrinter$TimeZoneDisplayKey = new FastDatePrinter$TimeZoneDisplayKey(timeZone, bl, n, locale);
        String string2 = (String)cTimeZoneDisplayCache.get(fastDatePrinter$TimeZoneDisplayKey);
        if (string2 == null && (string = cTimeZoneDisplayCache.putIfAbsent(fastDatePrinter$TimeZoneDisplayKey, string2 = timeZone.getDisplayName(bl, n, locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ void access$000(Appendable appendable, int n) {
        FastDatePrinter.appendDigits(appendable, n);
    }

    static /* synthetic */ void access$100(Appendable appendable, int n, int n2) {
        FastDatePrinter.appendFullDigits(appendable, n, n2);
    }
}

