/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.impl.WeakHashtable$1;
import org.apache.commons.logging.impl.WeakHashtable$Entry;
import org.apache.commons.logging.impl.WeakHashtable$Referenced;
import org.apache.commons.logging.impl.WeakHashtable$WeakKey;

public final class WeakHashtable
extends Hashtable {
    private static final long serialVersionUID = -1546036869799732453L;
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    public boolean containsKey(Object object) {
        WeakHashtable$Referenced weakHashtable$Referenced = new WeakHashtable$Referenced(object, null);
        return super.containsKey(weakHashtable$Referenced);
    }

    public Enumeration elements() {
        this.purge();
        return super.elements();
    }

    public Set entrySet() {
        this.purge();
        Set set = super.entrySet();
        HashSet<WeakHashtable$Entry> hashSet = new HashSet<WeakHashtable$Entry>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            WeakHashtable$Referenced weakHashtable$Referenced = (WeakHashtable$Referenced)entry.getKey();
            Object object = WeakHashtable$Referenced.access$100(weakHashtable$Referenced);
            Object v = entry.getValue();
            if (object == null) continue;
            WeakHashtable$Entry weakHashtable$Entry = new WeakHashtable$Entry(object, v, null);
            hashSet.add(weakHashtable$Entry);
        }
        return hashSet;
    }

    public Object get(Object object) {
        WeakHashtable$Referenced weakHashtable$Referenced = new WeakHashtable$Referenced(object, null);
        return super.get(weakHashtable$Referenced);
    }

    public Enumeration keys() {
        this.purge();
        Enumeration enumeration = super.keys();
        return new WeakHashtable$1(this, enumeration);
    }

    public Set keySet() {
        this.purge();
        Set set = super.keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            WeakHashtable$Referenced weakHashtable$Referenced = (WeakHashtable$Referenced)iterator.next();
            Object object = WeakHashtable$Referenced.access$100(weakHashtable$Referenced);
            if (object == null) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (object2 == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        WeakHashtable$Referenced weakHashtable$Referenced = new WeakHashtable$Referenced(object, this.queue, null);
        return super.put(weakHashtable$Referenced, object2);
    }

    public void putAll(Map map) {
        if (map != null) {
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Collection values() {
        this.purge();
        return super.values();
    }

    public synchronized Object remove(Object object) {
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new WeakHashtable$Referenced(object, null));
    }

    public boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    public int size() {
        this.purge();
        return super.size();
    }

    public String toString() {
        this.purge();
        return super.toString();
    }

    protected void rehash() {
        this.purge();
        super.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        ArrayList<WeakHashtable$Referenced> arrayList = new ArrayList<WeakHashtable$Referenced>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey weakHashtable$WeakKey;
            while ((weakHashtable$WeakKey = (WeakHashtable$WeakKey)this.queue.poll()) != null) {
                arrayList.add(WeakHashtable$WeakKey.access$400(weakHashtable$WeakKey));
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            super.remove(arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey weakHashtable$WeakKey = (WeakHashtable$WeakKey)this.queue.poll();
            if (weakHashtable$WeakKey != null) {
                super.remove(WeakHashtable$WeakKey.access$400(weakHashtable$WeakKey));
            }
        }
    }
}

