/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;

public class ConnectionConfig$Builder {
    private int bufferSize;
    private int fragmentSizeHint = -1;
    private Charset charset;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableInputAction;
    private MessageConstraints messageConstraints;

    ConnectionConfig$Builder() {
    }

    public ConnectionConfig$Builder setBufferSize(int n) {
        this.bufferSize = n;
        return this;
    }

    public ConnectionConfig$Builder setFragmentSizeHint(int n) {
        this.fragmentSizeHint = n;
        return this;
    }

    public ConnectionConfig$Builder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ConnectionConfig$Builder setMalformedInputAction(CodingErrorAction codingErrorAction) {
        this.malformedInputAction = codingErrorAction;
        if (codingErrorAction != null && this.charset == null) {
            this.charset = Consts.ASCII;
        }
        return this;
    }

    public ConnectionConfig$Builder setUnmappableInputAction(CodingErrorAction codingErrorAction) {
        this.unmappableInputAction = codingErrorAction;
        if (codingErrorAction != null && this.charset == null) {
            this.charset = Consts.ASCII;
        }
        return this;
    }

    public ConnectionConfig$Builder setMessageConstraints(MessageConstraints messageConstraints) {
        this.messageConstraints = messageConstraints;
        return this;
    }

    public ConnectionConfig build() {
        Charset charset = this.charset;
        if (charset == null && (this.malformedInputAction != null || this.unmappableInputAction != null)) {
            charset = Consts.ASCII;
        }
        int n = this.bufferSize > 0 ? this.bufferSize : 8192;
        int n2 = this.fragmentSizeHint >= 0 ? this.fragmentSizeHint : n;
        return new ConnectionConfig(n, n2, charset, this.malformedInputAction, this.unmappableInputAction, this.messageConstraints);
    }
}

