/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.X509KeyManager;
import org.apache.http.conn.ssl.PrivateKeyDetails;
import org.apache.http.conn.ssl.PrivateKeyStrategy;

class SSLContextBuilder$KeyManagerDelegate
implements X509KeyManager {
    private final X509KeyManager keyManager;
    private final PrivateKeyStrategy aliasStrategy;

    SSLContextBuilder$KeyManagerDelegate(X509KeyManager x509KeyManager, PrivateKeyStrategy privateKeyStrategy) {
        this.keyManager = x509KeyManager;
        this.aliasStrategy = privateKeyStrategy;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.keyManager.getClientAliases(string, principalArray);
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        for (String string : stringArray) {
            String[] stringArray2 = this.keyManager.getClientAliases(string, principalArray);
            if (stringArray2 == null) continue;
            for (String string2 : stringArray2) {
                hashMap.put(string2, new PrivateKeyDetails(string, this.keyManager.getCertificateChain(string2)));
            }
        }
        return this.aliasStrategy.chooseAlias(hashMap, socket);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.keyManager.getServerAliases(string, principalArray);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        String[] stringArray = this.keyManager.getServerAliases(string, principalArray);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                hashMap.put(string2, new PrivateKeyDetails(string, this.keyManager.getCertificateChain(string2)));
            }
        }
        return this.aliasStrategy.chooseAlias(hashMap, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this.keyManager.getCertificateChain(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.keyManager.getPrivateKey(string);
    }
}

