/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.net.IDN;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public final class PublicSuffixMatcher {
    private final Map<String, DomainType> rules;
    private final Map<String, DomainType> exceptions;

    public PublicSuffixMatcher(Collection<String> collection, Collection<String> collection2) {
        this(DomainType.UNKNOWN, collection, collection2);
    }

    public PublicSuffixMatcher(DomainType domainType, Collection<String> collection, Collection<String> collection2) {
        Args.notNull(domainType, "Domain type");
        Args.notNull(collection, "Domain suffix rules");
        this.rules = new ConcurrentHashMap<String, DomainType>(collection.size());
        for (String string : collection) {
            this.rules.put(string, domainType);
        }
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        if (collection2 != null) {
            for (String string : collection2) {
                this.exceptions.put(string, domainType);
            }
        }
    }

    public PublicSuffixMatcher(Collection<PublicSuffixList> collection) {
        Args.notNull(collection, "Domain suffix lists");
        this.rules = new ConcurrentHashMap<String, DomainType>();
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        for (PublicSuffixList publicSuffixList : collection) {
            DomainType domainType = publicSuffixList.getType();
            List<String> list = publicSuffixList.getRules();
            for (String string : list) {
                this.rules.put(string, domainType);
            }
            List<String> list2 = publicSuffixList.getExceptions();
            if (list2 == null) continue;
            for (String string : list2) {
                this.exceptions.put(string, domainType);
            }
        }
    }

    private static boolean hasEntry(Map<String, DomainType> map, String string, DomainType domainType) {
        if (map == null) {
            return false;
        }
        DomainType domainType2 = map.get(string);
        if (domainType2 == null) {
            return false;
        }
        return domainType == null || domainType2.equals((Object)domainType);
    }

    private boolean hasRule(String string, DomainType domainType) {
        return PublicSuffixMatcher.hasEntry(this.rules, string, domainType);
    }

    private boolean hasException(String string, DomainType domainType) {
        return PublicSuffixMatcher.hasEntry(this.exceptions, string, domainType);
    }

    public String getDomainRoot(String string) {
        return this.getDomainRoot(string, null);
    }

    public String getDomainRoot(String string, DomainType domainType) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(".")) {
            return null;
        }
        String string2 = null;
        String string3 = string.toLowerCase(Locale.ROOT);
        while (string3 != null) {
            String string4;
            if (this.hasException(IDN.toUnicode(string3), domainType)) {
                return string3;
            }
            if (this.hasRule(IDN.toUnicode(string3), domainType)) break;
            int n = string3.indexOf(46);
            String string5 = string4 = n != -1 ? string3.substring(n + 1) : null;
            if (string4 != null && this.hasRule("*." + IDN.toUnicode(string4), domainType)) break;
            if (n != -1) {
                string2 = string3;
            }
            string3 = string4;
        }
        return string2;
    }

    public boolean matches(String string) {
        return this.matches(string, null);
    }

    public boolean matches(String string, DomainType domainType) {
        if (string == null) {
            return false;
        }
        String string2 = this.getDomainRoot(string.startsWith(".") ? string.substring(1) : string, domainType);
        return string2 == null;
    }
}

