/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$MD4;

public class NTLMEngineImpl$CipherGen {
    protected final Random random;
    protected final long currentTime;
    protected final String domain;
    protected final String user;
    protected final String password;
    protected final byte[] challenge;
    protected final String target;
    protected final byte[] targetInformation;
    protected byte[] clientChallenge;
    protected byte[] clientChallenge2;
    protected byte[] secondaryKey;
    protected byte[] timestamp;
    protected byte[] lmHash = null;
    protected byte[] lmResponse = null;
    protected byte[] ntlmHash = null;
    protected byte[] ntlmResponse = null;
    protected byte[] ntlmv2Hash = null;
    protected byte[] lmv2Hash = null;
    protected byte[] lmv2Response = null;
    protected byte[] ntlmv2Blob = null;
    protected byte[] ntlmv2Response = null;
    protected byte[] ntlm2SessionResponse = null;
    protected byte[] lm2SessionResponse = null;
    protected byte[] lmUserSessionKey = null;
    protected byte[] ntlmUserSessionKey = null;
    protected byte[] ntlmv2UserSessionKey = null;
    protected byte[] ntlm2SessionResponseUserSessionKey = null;
    protected byte[] lanManagerSessionKey = null;

    @Deprecated
    public NTLMEngineImpl$CipherGen(String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        this(NTLMEngineImpl.access$000(), System.currentTimeMillis(), string, string2, string3, byArray, string4, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    public NTLMEngineImpl$CipherGen(Random random, long l, String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        this.random = random;
        this.currentTime = l;
        this.domain = string;
        this.target = string4;
        this.user = string2;
        this.password = string3;
        this.challenge = byArray;
        this.targetInformation = byArray2;
        this.clientChallenge = byArray3;
        this.clientChallenge2 = byArray4;
        this.secondaryKey = byArray5;
        this.timestamp = byArray6;
    }

    @Deprecated
    public NTLMEngineImpl$CipherGen(String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2) {
        this(NTLMEngineImpl.access$000(), System.currentTimeMillis(), string, string2, string3, byArray, string4, byArray2);
    }

    public NTLMEngineImpl$CipherGen(Random random, long l, String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2) {
        this(random, l, string, string2, string3, byArray, string4, byArray2, null, null, null, null);
    }

    public byte[] getClientChallenge() {
        if (this.clientChallenge == null) {
            this.clientChallenge = NTLMEngineImpl.access$100(this.random);
        }
        return this.clientChallenge;
    }

    public byte[] getClientChallenge2() {
        if (this.clientChallenge2 == null) {
            this.clientChallenge2 = NTLMEngineImpl.access$100(this.random);
        }
        return this.clientChallenge2;
    }

    public byte[] getSecondaryKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = NTLMEngineImpl.access$200(this.random);
        }
        return this.secondaryKey;
    }

    public byte[] getLMHash() {
        if (this.lmHash == null) {
            this.lmHash = NTLMEngineImpl.access$300(this.password);
        }
        return this.lmHash;
    }

    public byte[] getLMResponse() {
        if (this.lmResponse == null) {
            this.lmResponse = NTLMEngineImpl.access$400(this.getLMHash(), this.challenge);
        }
        return this.lmResponse;
    }

    public byte[] getNTLMHash() {
        if (this.ntlmHash == null) {
            this.ntlmHash = NTLMEngineImpl.access$500(this.password);
        }
        return this.ntlmHash;
    }

    public byte[] getNTLMResponse() {
        if (this.ntlmResponse == null) {
            this.ntlmResponse = NTLMEngineImpl.access$400(this.getNTLMHash(), this.challenge);
        }
        return this.ntlmResponse;
    }

    public byte[] getLMv2Hash() {
        if (this.lmv2Hash == null) {
            this.lmv2Hash = NTLMEngineImpl.access$600(this.domain, this.user, this.getNTLMHash());
        }
        return this.lmv2Hash;
    }

    public byte[] getNTLMv2Hash() {
        if (this.ntlmv2Hash == null) {
            this.ntlmv2Hash = NTLMEngineImpl.access$700(this.domain, this.user, this.getNTLMHash());
        }
        return this.ntlmv2Hash;
    }

    public byte[] getTimestamp() {
        if (this.timestamp == null) {
            long l = this.currentTime;
            l += 11644473600000L;
            l *= 10000L;
            this.timestamp = new byte[8];
            for (int i = 0; i < 8; ++i) {
                this.timestamp[i] = (byte)l;
                l >>>= 8;
            }
        }
        return this.timestamp;
    }

    public byte[] getNTLMv2Blob() {
        if (this.ntlmv2Blob == null) {
            this.ntlmv2Blob = NTLMEngineImpl.access$800(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
        }
        return this.ntlmv2Blob;
    }

    public byte[] getNTLMv2Response() {
        if (this.ntlmv2Response == null) {
            this.ntlmv2Response = NTLMEngineImpl.access$900(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
        }
        return this.ntlmv2Response;
    }

    public byte[] getLMv2Response() {
        if (this.lmv2Response == null) {
            this.lmv2Response = NTLMEngineImpl.access$900(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
        }
        return this.lmv2Response;
    }

    public byte[] getNTLM2SessionResponse() {
        if (this.ntlm2SessionResponse == null) {
            this.ntlm2SessionResponse = NTLMEngineImpl.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
        }
        return this.ntlm2SessionResponse;
    }

    public byte[] getLM2SessionResponse() {
        if (this.lm2SessionResponse == null) {
            byte[] byArray = this.getClientChallenge();
            this.lm2SessionResponse = new byte[24];
            System.arraycopy(byArray, 0, this.lm2SessionResponse, 0, byArray.length);
            Arrays.fill(this.lm2SessionResponse, byArray.length, this.lm2SessionResponse.length, (byte)0);
        }
        return this.lm2SessionResponse;
    }

    public byte[] getLMUserSessionKey() {
        if (this.lmUserSessionKey == null) {
            this.lmUserSessionKey = new byte[16];
            System.arraycopy(this.getLMHash(), 0, this.lmUserSessionKey, 0, 8);
            Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
        }
        return this.lmUserSessionKey;
    }

    public byte[] getNTLMUserSessionKey() {
        if (this.ntlmUserSessionKey == null) {
            NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
            nTLMEngineImpl$MD4.update(this.getNTLMHash());
            this.ntlmUserSessionKey = nTLMEngineImpl$MD4.getOutput();
        }
        return this.ntlmUserSessionKey;
    }

    public byte[] getNTLMv2UserSessionKey() {
        if (this.ntlmv2UserSessionKey == null) {
            byte[] byArray = this.getNTLMv2Hash();
            byte[] byArray2 = new byte[16];
            System.arraycopy(this.getNTLMv2Response(), 0, byArray2, 0, 16);
            this.ntlmv2UserSessionKey = NTLMEngineImpl.hmacMD5(byArray2, byArray);
        }
        return this.ntlmv2UserSessionKey;
    }

    public byte[] getNTLM2SessionResponseUserSessionKey() {
        if (this.ntlm2SessionResponseUserSessionKey == null) {
            byte[] byArray = this.getLM2SessionResponse();
            byte[] byArray2 = new byte[this.challenge.length + byArray.length];
            System.arraycopy(this.challenge, 0, byArray2, 0, this.challenge.length);
            System.arraycopy(byArray, 0, byArray2, this.challenge.length, byArray.length);
            this.ntlm2SessionResponseUserSessionKey = NTLMEngineImpl.hmacMD5(byArray2, this.getNTLMUserSessionKey());
        }
        return this.ntlm2SessionResponseUserSessionKey;
    }

    public byte[] getLanManagerSessionKey() {
        if (this.lanManagerSessionKey == null) {
            try {
                byte[] byArray = new byte[14];
                System.arraycopy(this.getLMHash(), 0, byArray, 0, 8);
                Arrays.fill(byArray, 8, byArray.length, (byte)-67);
                Key key = NTLMEngineImpl.access$1000(byArray, 0);
                Key key2 = NTLMEngineImpl.access$1000(byArray, 7);
                byte[] byArray2 = new byte[8];
                System.arraycopy(this.getLMResponse(), 0, byArray2, 0, byArray2.length);
                Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, key);
                byte[] byArray3 = cipher.doFinal(byArray2);
                cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, key2);
                byte[] byArray4 = cipher.doFinal(byArray2);
                this.lanManagerSessionKey = new byte[16];
                System.arraycopy(byArray3, 0, this.lanManagerSessionKey, 0, byArray3.length);
                System.arraycopy(byArray4, 0, this.lanManagerSessionKey, byArray3.length, byArray4.length);
            }
            catch (Exception exception) {
                throw new NTLMEngineException(exception.getMessage(), exception);
            }
        }
        return this.lanManagerSessionKey;
    }
}

