/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.http.impl.auth.NTLMEngineImpl$Mode;

class NTLMEngineImpl$Handle {
    private final byte[] exportedSessionKey;
    private byte[] signingKey;
    private byte[] sealingKey;
    private final Cipher rc4;
    final NTLMEngineImpl$Mode mode;
    private final boolean isConnection;
    int sequenceNumber = 0;

    NTLMEngineImpl$Handle(byte[] byArray, NTLMEngineImpl$Mode nTLMEngineImpl$Mode, boolean bl) {
        this.exportedSessionKey = byArray;
        this.isConnection = bl;
        this.mode = nTLMEngineImpl$Mode;
        try {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            MessageDigest messageDigest2 = NTLMEngineImpl.getMD5();
            messageDigest.update(byArray);
            messageDigest2.update(byArray);
            if (nTLMEngineImpl$Mode == NTLMEngineImpl$Mode.CLIENT) {
                messageDigest.update(NTLMEngineImpl.access$1100());
                messageDigest2.update(NTLMEngineImpl.access$1200());
            } else {
                messageDigest.update(NTLMEngineImpl.access$1300());
                messageDigest2.update(NTLMEngineImpl.access$1400());
            }
            this.signingKey = messageDigest.digest();
            this.sealingKey = messageDigest2.digest();
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
        this.rc4 = this.initCipher();
    }

    public byte[] getSigningKey() {
        return this.signingKey;
    }

    public byte[] getSealingKey() {
        return this.sealingKey;
    }

    private Cipher initCipher() {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("RC4");
            if (this.mode == NTLMEngineImpl$Mode.CLIENT) {
                cipher.init(1, new SecretKeySpec(this.sealingKey, "RC4"));
            } else {
                cipher.init(2, new SecretKeySpec(this.sealingKey, "RC4"));
            }
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
        return cipher;
    }

    private void advanceMessageSequence() {
        if (!this.isConnection) {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            messageDigest.update(this.sealingKey);
            byte[] byArray = new byte[4];
            NTLMEngineImpl.writeULong(byArray, this.sequenceNumber, 0);
            messageDigest.update(byArray);
            this.sealingKey = messageDigest.digest();
            this.initCipher();
        }
        ++this.sequenceNumber;
    }

    private byte[] encrypt(byte[] byArray) {
        return this.rc4.update(byArray);
    }

    private byte[] decrypt(byte[] byArray) {
        return this.rc4.update(byArray);
    }

    private byte[] computeSignature(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        byArray2[0] = 1;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(this.signingKey);
        nTLMEngineImpl$HMACMD5.update(NTLMEngineImpl.access$1500(this.sequenceNumber));
        nTLMEngineImpl$HMACMD5.update(byArray);
        byte[] byArray3 = nTLMEngineImpl$HMACMD5.getOutput();
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray3, 0, byArray4, 0, 8);
        byte[] byArray5 = this.encrypt(byArray4);
        System.arraycopy(byArray5, 0, byArray2, 4, 8);
        NTLMEngineImpl.access$1600(byArray2, 12, this.sequenceNumber);
        return byArray2;
    }

    private boolean validateSignature(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.computeSignature(byArray2);
        return Arrays.equals(byArray, byArray3);
    }

    public byte[] signAndEncryptMessage(byte[] byArray) {
        byte[] byArray2 = this.encrypt(byArray);
        byte[] byArray3 = this.computeSignature(byArray);
        byte[] byArray4 = new byte[byArray3.length + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        this.advanceMessageSequence();
        return byArray4;
    }

    public byte[] decryptAndVerifySignedMessage(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, byArray3, 0, byArray3.length);
        byte[] byArray4 = this.decrypt(byArray3);
        if (!this.validateSignature(byArray2, byArray4)) {
            throw new NTLMEngineException("Wrong signature");
        }
        this.advanceMessageSequence();
        return byArray4;
    }
}

