/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Consts;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.http.impl.auth.NTLMEngineImpl$MD4;
import org.apache.http.impl.auth.NTLMEngineImpl$Type1Message;
import org.apache.http.impl.auth.NTLMEngineImpl$Type2Message;
import org.apache.http.impl.auth.NTLMEngineImpl$Type3Message;

final class NTLMEngineImpl
implements NTLMEngine {
    private static final Charset UNICODE_LITTLE_UNMARKED = Charset.forName("UnicodeLittleUnmarked");
    private static final Charset DEFAULT_CHARSET = Consts.ASCII;
    static final int FLAG_REQUEST_UNICODE_ENCODING = 1;
    static final int FLAG_REQUEST_OEM_ENCODING = 2;
    static final int FLAG_REQUEST_TARGET = 4;
    static final int FLAG_REQUEST_SIGN = 16;
    static final int FLAG_REQUEST_SEAL = 32;
    static final int FLAG_REQUEST_LAN_MANAGER_KEY = 128;
    static final int FLAG_REQUEST_NTLMv1 = 512;
    static final int FLAG_DOMAIN_PRESENT = 4096;
    static final int FLAG_WORKSTATION_PRESENT = 8192;
    static final int FLAG_REQUEST_ALWAYS_SIGN = 32768;
    static final int FLAG_REQUEST_NTLM2_SESSION = 524288;
    static final int FLAG_REQUEST_VERSION = 0x2000000;
    static final int FLAG_TARGETINFO_PRESENT = 0x800000;
    static final int FLAG_REQUEST_128BIT_KEY_EXCH = 0x20000000;
    static final int FLAG_REQUEST_EXPLICIT_KEY_EXCH = 0x40000000;
    static final int FLAG_REQUEST_56BIT_ENCRYPTION = Integer.MIN_VALUE;
    static final int MSV_AV_EOL = 0;
    static final int MSV_AV_NB_COMPUTER_NAME = 1;
    static final int MSV_AV_NB_DOMAIN_NAME = 2;
    static final int MSV_AV_DNS_COMPUTER_NAME = 3;
    static final int MSV_AV_DNS_DOMAIN_NAME = 4;
    static final int MSV_AV_DNS_TREE_NAME = 5;
    static final int MSV_AV_FLAGS = 6;
    static final int MSV_AV_TIMESTAMP = 7;
    static final int MSV_AV_SINGLE_HOST = 8;
    static final int MSV_AV_TARGET_NAME = 9;
    static final int MSV_AV_CHANNEL_BINDINGS = 10;
    static final int MSV_AV_FLAGS_ACCOUNT_AUTH_CONSTAINED = 1;
    static final int MSV_AV_FLAGS_MIC = 2;
    static final int MSV_AV_FLAGS_UNTRUSTED_TARGET_SPN = 4;
    private static final SecureRandom RND_GEN;
    private static final byte[] SIGNATURE;
    private static final byte[] SIGN_MAGIC_SERVER;
    private static final byte[] SIGN_MAGIC_CLIENT;
    private static final byte[] SEAL_MAGIC_SERVER;
    private static final byte[] SEAL_MAGIC_CLIENT;
    private static final byte[] MAGIC_TLS_SERVER_ENDPOINT;
    private static final String TYPE_1_MESSAGE;

    private static byte[] getNullTerminatedAsciiString(String string) {
        byte[] byArray = string.getBytes(Consts.ASCII);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    NTLMEngineImpl() {
    }

    static String getType1Message(String string, String string2) {
        return TYPE_1_MESSAGE;
    }

    static String getType3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) {
        return new NTLMEngineImpl$Type3Message(string4, string3, string, string2, byArray, n, string5, byArray2).getResponse();
    }

    static String getType3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2, Certificate certificate, byte[] byArray3, byte[] byArray4) {
        return new NTLMEngineImpl$Type3Message(string4, string3, string, string2, byArray, n, string5, byArray2, certificate, byArray3, byArray4).getResponse();
    }

    private static int readULong(byte[] byArray, int n) {
        if (byArray.length < n + 4) {
            return 0;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n) {
        if (byArray.length < n + 2) {
            return 0;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n) {
        int n2 = NTLMEngineImpl.readUShort(byArray, n);
        int n3 = NTLMEngineImpl.readULong(byArray, n + 4);
        if (byArray.length < n3 + n2) {
            return new byte[n2];
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge(Random random) {
        byte[] byArray = new byte[8];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeSecondaryKey(Random random) {
        byte[] byArray = new byte[16];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(byArray);
        }
        return byArray;
    }

    static byte[] hmacMD5(byte[] byArray, byte[] byArray2) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray2);
        nTLMEngineImpl$HMACMD5.update(byArray);
        return nTLMEngineImpl$HMACMD5.getOutput();
    }

    static byte[] RC4(byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, new SecretKeySpec(byArray2, "RC4"));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    static byte[] ntlm2SessionResponse(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray4, 0, byArray5, 0, 8);
            return NTLMEngineImpl.lmResponse(byArray, byArray5);
        }
        catch (Exception exception) {
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)exception;
            }
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmHash(String string) {
        try {
            byte[] byArray = string.toUpperCase(Locale.ROOT).getBytes(Consts.ASCII);
            int n = Math.min(byArray.length, 14);
            byte[] byArray2 = new byte[14];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            Key key = NTLMEngineImpl.createDESKey(byArray2, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray2, 7);
            byte[] byArray3 = "KGS!@#$%".getBytes(Consts.ASCII);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray3);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray3);
            byte[] byArray6 = new byte[16];
            System.arraycopy(byArray4, 0, byArray6, 0, 8);
            System.arraycopy(byArray5, 0, byArray6, 8, 8);
            return byArray6;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] ntlmHash(String string) {
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        byte[] byArray = string.getBytes(UNICODE_LITTLE_UNMARKED);
        NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
        nTLMEngineImpl$MD4.update(byArray);
        return nTLMEngineImpl$MD4.getOutput();
    }

    private static byte[] lmv2Hash(String string, String string2, byte[] byArray) {
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
        nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (string != null) {
            nTLMEngineImpl$HMACMD5.update(string.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return nTLMEngineImpl$HMACMD5.getOutput();
    }

    private static byte[] ntlmv2Hash(String string, String string2, byte[] byArray) {
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
        nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (string != null) {
            nTLMEngineImpl$HMACMD5.update(string.getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return nTLMEngineImpl$HMACMD5.getOutput();
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[21];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            Key key = NTLMEngineImpl.createDESKey(byArray3, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray3, 7);
            Key key3 = NTLMEngineImpl.createDESKey(byArray3, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray2);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray2);
            cipher.init(1, key3);
            byte[] byArray6 = cipher.doFinal(byArray2);
            byte[] byArray7 = new byte[24];
            System.arraycopy(byArray4, 0, byArray7, 0, 8);
            System.arraycopy(byArray5, 0, byArray7, 8, 8);
            System.arraycopy(byArray6, 0, byArray7, 16, 8);
            return byArray7;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
        nTLMEngineImpl$HMACMD5.update(byArray2);
        nTLMEngineImpl$HMACMD5.update(byArray3);
        byte[] byArray4 = nTLMEngineImpl$HMACMD5.getOutput();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    private static byte[] encodeLong(int n) {
        byte[] byArray = new byte[4];
        NTLMEngineImpl.encodeLong(byArray, 0, n);
        return byArray;
    }

    private static void encodeLong(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[]{1, 1, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        byte[] byArray6 = new byte[]{0, 0, 0, 0};
        byte[] byArray7 = new byte[]{0, 0, 0, 0};
        byte[] byArray8 = new byte[byArray4.length + byArray5.length + byArray3.length + 8 + byArray6.length + byArray2.length + byArray7.length];
        int n = 0;
        System.arraycopy(byArray4, 0, byArray8, n, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, n += byArray4.length, byArray5.length);
        System.arraycopy(byArray3, 0, byArray8, n += byArray5.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray8, n += byArray3.length, 8);
        System.arraycopy(byArray6, 0, byArray8, n += 8, byArray6.length);
        System.arraycopy(byArray2, 0, byArray8, n += byArray6.length, byArray2.length);
        System.arraycopy(byArray7, 0, byArray8, n += byArray2.length, byArray7.length);
        n += byArray7.length;
        return byArray8;
    }

    private static Key createDESKey(byte[] byArray, int n) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLMEngineImpl.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            byte by = byArray[i];
            boolean bl2 = bl = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl) {
                int n = i;
                byArray[n] = (byte)(byArray[n] | 1);
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
        }
    }

    private static Charset getCharset(int n) {
        if ((n & 1) == 0) {
            return DEFAULT_CHARSET;
        }
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        return UNICODE_LITTLE_UNMARKED;
    }

    private static String stripDotSuffix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String convertHost(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    private static String convertDomain(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    static void writeUShort(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
    }

    static void writeULong(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    static int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    static int G(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    static int rotintlft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("MD5 message digest doesn't seem to exist - fatal error: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    @Override
    public String generateType1Msg(String string, String string2) {
        return NTLMEngineImpl.getType1Message(string2, string);
    }

    @Override
    public String generateType3Msg(String string, String string2, String string3, String string4, String string5) {
        NTLMEngineImpl$Type2Message nTLMEngineImpl$Type2Message = new NTLMEngineImpl$Type2Message(string5);
        return NTLMEngineImpl.getType3Message(string, string2, string4, string3, nTLMEngineImpl$Type2Message.getChallenge(), nTLMEngineImpl$Type2Message.getFlags(), nTLMEngineImpl$Type2Message.getTarget(), nTLMEngineImpl$Type2Message.getTargetInfo());
    }

    static /* synthetic */ SecureRandom access$000() {
        return RND_GEN;
    }

    static /* synthetic */ byte[] access$100(Random random) {
        return NTLMEngineImpl.makeRandomChallenge(random);
    }

    static /* synthetic */ byte[] access$200(Random random) {
        return NTLMEngineImpl.makeSecondaryKey(random);
    }

    static /* synthetic */ byte[] access$300(String string) {
        return NTLMEngineImpl.lmHash(string);
    }

    static /* synthetic */ byte[] access$400(byte[] byArray, byte[] byArray2) {
        return NTLMEngineImpl.lmResponse(byArray, byArray2);
    }

    static /* synthetic */ byte[] access$500(String string) {
        return NTLMEngineImpl.ntlmHash(string);
    }

    static /* synthetic */ byte[] access$600(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.lmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$700(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.ntlmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$800(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.createBlob(byArray, byArray2, byArray3);
    }

    static /* synthetic */ byte[] access$900(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.lmv2Response(byArray, byArray2, byArray3);
    }

    static /* synthetic */ Key access$1000(byte[] byArray, int n) {
        return NTLMEngineImpl.createDESKey(byArray, n);
    }

    static /* synthetic */ byte[] access$1100() {
        return SIGN_MAGIC_CLIENT;
    }

    static /* synthetic */ byte[] access$1200() {
        return SEAL_MAGIC_CLIENT;
    }

    static /* synthetic */ byte[] access$1300() {
        return SIGN_MAGIC_SERVER;
    }

    static /* synthetic */ byte[] access$1400() {
        return SEAL_MAGIC_SERVER;
    }

    static /* synthetic */ byte[] access$1500(int n) {
        return NTLMEngineImpl.encodeLong(n);
    }

    static /* synthetic */ void access$1600(byte[] byArray, int n, int n2) {
        NTLMEngineImpl.encodeLong(byArray, n, n2);
    }

    static /* synthetic */ Charset access$1700() {
        return DEFAULT_CHARSET;
    }

    static /* synthetic */ byte[] access$1800() {
        return SIGNATURE;
    }

    static /* synthetic */ int access$1900(byte[] byArray, int n) {
        return NTLMEngineImpl.readUShort(byArray, n);
    }

    static /* synthetic */ int access$2000(byte[] byArray, int n) {
        return NTLMEngineImpl.readULong(byArray, n);
    }

    static /* synthetic */ byte[] access$2100(byte[] byArray, int n) {
        return NTLMEngineImpl.readSecurityBuffer(byArray, n);
    }

    static /* synthetic */ String access$2200(String string) {
        return NTLMEngineImpl.convertHost(string);
    }

    static /* synthetic */ String access$2300(String string) {
        return NTLMEngineImpl.convertDomain(string);
    }

    static /* synthetic */ Charset access$2400() {
        return UNICODE_LITTLE_UNMARKED;
    }

    static /* synthetic */ Charset access$2500(int n) {
        return NTLMEngineImpl.getCharset(n);
    }

    static /* synthetic */ byte[] access$2600() {
        return MAGIC_TLS_SERVER_ENDPOINT;
    }

    static {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RND_GEN = secureRandom;
        SIGNATURE = NTLMEngineImpl.getNullTerminatedAsciiString("NTLMSSP");
        SIGN_MAGIC_SERVER = NTLMEngineImpl.getNullTerminatedAsciiString("session key to server-to-client signing key magic constant");
        SIGN_MAGIC_CLIENT = NTLMEngineImpl.getNullTerminatedAsciiString("session key to client-to-server signing key magic constant");
        SEAL_MAGIC_SERVER = NTLMEngineImpl.getNullTerminatedAsciiString("session key to server-to-client sealing key magic constant");
        SEAL_MAGIC_CLIENT = NTLMEngineImpl.getNullTerminatedAsciiString("session key to client-to-server sealing key magic constant");
        MAGIC_TLS_SERVER_ENDPOINT = "tls-server-end-point:".getBytes(Consts.ASCII);
        TYPE_1_MESSAGE = new NTLMEngineImpl$Type1Message().getResponse();
    }
}

