/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMScheme$State;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public class NTLMScheme
extends AuthSchemeBase {
    private final NTLMEngine engine;
    private NTLMScheme$State state;
    private String challenge;

    public NTLMScheme(NTLMEngine nTLMEngine) {
        Args.notNull(nTLMEngine, "NTLM engine");
        this.engine = nTLMEngine;
        this.state = NTLMScheme$State.UNINITIATED;
        this.challenge = null;
    }

    public NTLMScheme() {
        this(new NTLMEngineImpl());
    }

    @Override
    public String getSchemeName() {
        return "ntlm";
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n, int n2) {
        this.challenge = charArrayBuffer.substringTrimmed(n, n2);
        if (this.challenge.isEmpty()) {
            this.state = this.state == NTLMScheme$State.UNINITIATED ? NTLMScheme$State.CHALLENGE_RECEIVED : NTLMScheme$State.FAILED;
        } else {
            if (this.state.compareTo(NTLMScheme$State.MSG_TYPE1_GENERATED) < 0) {
                this.state = NTLMScheme$State.FAILED;
                throw new MalformedChallengeException("Out of sequence NTLM response message");
            }
            if (this.state == NTLMScheme$State.MSG_TYPE1_GENERATED) {
                this.state = NTLMScheme$State.MSG_TYPE2_RECEVIED;
            }
        }
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) {
        NTCredentials nTCredentials = null;
        try {
            nTCredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        String string = null;
        if (this.state == NTLMScheme$State.FAILED) {
            throw new AuthenticationException("NTLM authentication failed");
        }
        if (this.state == NTLMScheme$State.CHALLENGE_RECEIVED) {
            string = this.engine.generateType1Msg(nTCredentials.getDomain(), nTCredentials.getWorkstation());
            this.state = NTLMScheme$State.MSG_TYPE1_GENERATED;
        } else if (this.state == NTLMScheme$State.MSG_TYPE2_RECEVIED) {
            string = this.engine.generateType3Msg(nTCredentials.getUserName(), nTCredentials.getPassword(), nTCredentials.getDomain(), nTCredentials.getWorkstation(), this.challenge);
            this.state = NTLMScheme$State.MSG_TYPE3_GENERATED;
        } else {
            throw new AuthenticationException("Unexpected state: " + (Object)((Object)this.state));
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": NTLM ");
        charArrayBuffer.append(string);
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public boolean isComplete() {
        return this.state == NTLMScheme$State.MSG_TYPE3_GENERATED || this.state == NTLMScheme$State.FAILED;
    }
}

