/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class SystemDefaultCredentialsProvider
implements CredentialsProvider {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    private static String translateScheme(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SCHEME_MAP.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.internal.setCredentials(authScope, credentials);
    }

    private static PasswordAuthentication getSystemCreds(String string, AuthScope authScope, Authenticator.RequestorType requestorType) {
        return Authenticator.requestPasswordAuthentication(authScope.getHost(), null, authScope.getPort(), string, null, SystemDefaultCredentialsProvider.translateScheme(authScope.getScheme()), null, requestorType);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        Args.notNull(authScope, "Auth scope");
        Credentials credentials = this.internal.getCredentials(authScope);
        if (credentials != null) {
            return credentials;
        }
        String string = authScope.getHost();
        if (string != null) {
            String string2;
            String string3;
            HttpHost httpHost = authScope.getOrigin();
            String string4 = httpHost != null ? httpHost.getSchemeName() : (authScope.getPort() == 443 ? "https" : "http");
            PasswordAuthentication passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds(string4, authScope, Authenticator.RequestorType.SERVER);
            if (passwordAuthentication == null) {
                passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds(string4, authScope, Authenticator.RequestorType.PROXY);
            }
            if (passwordAuthentication == null && (string3 = System.getProperty(string4 + ".proxyHost")) != null && (string2 = System.getProperty(string4 + ".proxyPort")) != null) {
                try {
                    String string5;
                    AuthScope authScope2 = new AuthScope(string3, Integer.parseInt(string2));
                    if (authScope.match(authScope2) >= 0 && (string5 = System.getProperty(string4 + ".proxyUser")) != null) {
                        String string6 = System.getProperty(string4 + ".proxyPassword");
                        passwordAuthentication = new PasswordAuthentication(string5, string6 != null ? string6.toCharArray() : new char[]{});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (passwordAuthentication != null) {
                string3 = System.getProperty("http.auth.ntlm.domain");
                if (string3 != null) {
                    return new NTCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()), null, string3);
                }
                if ("NTLM".equalsIgnoreCase(authScope.getScheme())) {
                    return new NTCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()), null, null);
                }
                return new UsernamePasswordCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("Basic".toUpperCase(Locale.ROOT), "Basic");
        SCHEME_MAP.put("Digest".toUpperCase(Locale.ROOT), "Digest");
        SCHEME_MAP.put("NTLM".toUpperCase(Locale.ROOT), "NTLM");
        SCHEME_MAP.put("Negotiate".toUpperCase(Locale.ROOT), "SPNEGO");
        SCHEME_MAP.put("Kerberos".toUpperCase(Locale.ROOT), "Kerberos");
    }
}

