/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.impl.conn.IdleConnectionHandler$TimeValues;

@Deprecated
public class IdleConnectionHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<HttpConnection, IdleConnectionHandler$TimeValues> connectionToTimes = new HashMap<HttpConnection, IdleConnectionHandler$TimeValues>();

    public void add(HttpConnection httpConnection, long l, TimeUnit timeUnit) {
        long l2 = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding connection at: " + l2);
        }
        this.connectionToTimes.put(httpConnection, new IdleConnectionHandler$TimeValues(l2, l, timeUnit));
    }

    public boolean remove(HttpConnection httpConnection) {
        IdleConnectionHandler$TimeValues idleConnectionHandler$TimeValues = this.connectionToTimes.remove(httpConnection);
        if (idleConnectionHandler$TimeValues == null) {
            this.log.warn("Removing a connection that never existed!");
            return true;
        }
        return System.currentTimeMillis() <= IdleConnectionHandler$TimeValues.access$000(idleConnectionHandler$TimeValues);
    }

    public void removeAll() {
        this.connectionToTimes.clear();
    }

    public void closeIdleConnections(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for connections, idle timeout: " + l2);
        }
        for (Map.Entry<HttpConnection, IdleConnectionHandler$TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection httpConnection = entry.getKey();
            IdleConnectionHandler$TimeValues idleConnectionHandler$TimeValues = entry.getValue();
            long l3 = IdleConnectionHandler$TimeValues.access$100(idleConnectionHandler$TimeValues);
            if (l3 > l2) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing idle connection, connection time: " + l3);
            }
            try {
                httpConnection.close();
            }
            catch (IOException iOException) {
                this.log.debug("I/O error closing connection", iOException);
            }
        }
    }

    public void closeExpiredConnections() {
        long l = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for expired connections, now: " + l);
        }
        for (Map.Entry<HttpConnection, IdleConnectionHandler$TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection httpConnection = entry.getKey();
            IdleConnectionHandler$TimeValues idleConnectionHandler$TimeValues = entry.getValue();
            if (IdleConnectionHandler$TimeValues.access$000(idleConnectionHandler$TimeValues) > l) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing connection, expired @: " + IdleConnectionHandler$TimeValues.access$000(idleConnectionHandler$TimeValues));
            }
            try {
                httpConnection.close();
            }
            catch (IOException iOException) {
                this.log.debug("I/O error closing connection", iOException);
            }
        }
    }
}

