/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.pool.AbstractConnPool$1;
import org.apache.http.pool.AbstractConnPool$2;
import org.apache.http.pool.AbstractConnPool$3;
import org.apache.http.pool.AbstractConnPool$4;
import org.apache.http.pool.ConnFactory;
import org.apache.http.pool.ConnPool;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolEntryCallback;
import org.apache.http.pool.PoolStats;
import org.apache.http.pool.RouteSpecificPool;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPool<T, E>,
ConnPoolControl<T> {
    private final Lock lock;
    private final Condition condition;
    private final ConnFactory<T, C> connFactory;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<Future<E>> pending;
    private final Map<T, Integer> maxPerRoute;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;
    private volatile int validateAfterInactivity;

    public AbstractConnPool(ConnFactory<T, C> connFactory, int n, int n2) {
        this.connFactory = Args.notNull(connFactory, "Connection factory");
        this.defaultMaxPerRoute = Args.positive(n, "Max per route value");
        this.maxTotal = Args.positive(n2, "Max total value");
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
    }

    protected abstract E createEntry(T var1, C var2);

    protected void onLease(E e2) {
    }

    protected void onRelease(E e2) {
    }

    protected void onReuse(E e2) {
    }

    protected boolean validate(E e2) {
        return true;
    }

    public boolean isShutdown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (PoolEntry object : this.available) {
                object.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.available.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, C, E> getPool(T t) {
        AbstractConnPool$1 abstractConnPool$1 = this.routeToPool.get(t);
        if (abstractConnPool$1 == null) {
            abstractConnPool$1 = new AbstractConnPool$1(this, t, t);
            this.routeToPool.put(t, abstractConnPool$1);
        }
        return abstractConnPool$1;
    }

    @Override
    public Future<E> lease(T t, Object object, FutureCallback<E> futureCallback) {
        Args.notNull(t, "Route");
        Asserts.check(!this.isShutDown, "Connection pool shut down");
        return new AbstractConnPool$2(this, futureCallback, t, object);
    }

    public Future<E> lease(T t, Object object) {
        return this.lease(t, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getPoolEntryBlocking(T t, Object object, long l, TimeUnit timeUnit, Future<E> future) {
        Date date = null;
        if (l > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l));
        }
        this.lock.lock();
        try {
            int n;
            RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t);
            do {
                int n2;
                E e2;
                Asserts.check(!this.isShutDown, "Connection pool shut down");
                while ((e2 = routeSpecificPool.getFree(object)) != null) {
                    if (((PoolEntry)e2).isExpired(System.currentTimeMillis())) {
                        ((PoolEntry)e2).close();
                    }
                    if (!((PoolEntry)e2).isClosed()) break;
                    this.available.remove(e2);
                    routeSpecificPool.free(e2, false);
                }
                if (e2 != null) {
                    this.available.remove(e2);
                    this.leased.add(e2);
                    this.onReuse(e2);
                    E e3 = e2;
                    return e3;
                }
                int n3 = this.getMax(t);
                int n4 = Math.max(0, routeSpecificPool.getAllocatedCount() + 1 - n3);
                if (n4 > 0) {
                    E e4;
                    for (n = 0; n < n4 && (e4 = routeSpecificPool.getLastUsed()) != null; ++n) {
                        ((PoolEntry)e4).close();
                        this.available.remove(e4);
                        routeSpecificPool.remove(e4);
                    }
                }
                if (routeSpecificPool.getAllocatedCount() < n3 && (n2 = Math.max(this.maxTotal - (n = this.leased.size()), 0)) > 0) {
                    RouteSpecificPool routeSpecificPool2;
                    Object object2;
                    int n5 = this.available.size();
                    if (n5 > n2 - 1 && !this.available.isEmpty()) {
                        object2 = (PoolEntry)this.available.removeLast();
                        ((PoolEntry)object2).close();
                        routeSpecificPool2 = this.getPool(((PoolEntry)object2).getRoute());
                        routeSpecificPool2.remove(object2);
                    }
                    object2 = this.connFactory.create(t);
                    e2 = routeSpecificPool.add(object2);
                    this.leased.add(e2);
                    routeSpecificPool2 = e2;
                    return (E)routeSpecificPool2;
                }
                n = 0;
                try {
                    if (future.isCancelled()) {
                        throw new InterruptedException("Operation interrupted");
                    }
                    routeSpecificPool.queue(future);
                    this.pending.add(future);
                    if (date != null) {
                        n = this.condition.awaitUntil(date) ? 1 : 0;
                    } else {
                        this.condition.await();
                        n = 1;
                    }
                    if (future.isCancelled()) {
                        throw new InterruptedException("Operation interrupted");
                    }
                }
                finally {
                    routeSpecificPool.unqueue(future);
                    this.pending.remove(future);
                }
            } while (n != 0 || date == null || date.getTime() > System.currentTimeMillis());
            throw new TimeoutException("Timeout waiting for connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(E e2, boolean bl) {
        this.lock.lock();
        try {
            if (this.leased.remove(e2)) {
                RouteSpecificPool routeSpecificPool = this.getPool(((PoolEntry)e2).getRoute());
                routeSpecificPool.free(e2, bl);
                if (bl && !this.isShutDown) {
                    this.available.addFirst(e2);
                } else {
                    ((PoolEntry)e2).close();
                }
                this.onRelease(e2);
                Future<E> future = routeSpecificPool.nextPending();
                if (future != null) {
                    this.pending.remove(future);
                } else {
                    future = this.pending.poll();
                }
                if (future != null) {
                    this.condition.signalAll();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMax(T t) {
        Integer n = this.maxPerRoute.get(t);
        if (n != null) {
            return n;
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxTotal(int n) {
        Args.positive(n, "Max value");
        this.lock.lock();
        try {
            this.maxTotal = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n = this.maxTotal;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultMaxPerRoute(int n) {
        Args.positive(n, "Max per route value");
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n = this.defaultMaxPerRoute;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxPerRoute(T t, int n) {
        Args.notNull(t, "Route");
        Args.positive(n, "Max per route value");
        this.lock.lock();
        try {
            this.maxPerRoute.put(t, n);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPerRoute(T t) {
        Args.notNull(t, "Route");
        this.lock.lock();
        try {
            int n = this.getMax(t);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getStats(T t) {
        Args.notNull(t, "Route");
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t);
            PoolStats poolStats = new PoolStats(routeSpecificPool.getLeasedCount(), routeSpecificPool.getPendingCount(), routeSpecificPool.getAvailableCount(), this.getMax(t));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getRoutes() {
        this.lock.lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.routeToPool.keySet());
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumAvailable(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                poolEntryCallback.process(poolEntry);
                if (!poolEntry.isClosed()) continue;
                RouteSpecificPool routeSpecificPool = this.getPool(poolEntry.getRoute());
                routeSpecificPool.remove(poolEntry);
                iterator.remove();
            }
            this.purgePoolMap();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumLeased(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            for (PoolEntry poolEntry : this.leased) {
                poolEntryCallback.process(poolEntry);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, RouteSpecificPool<T, C, E>>> iterator = this.routeToPool.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, RouteSpecificPool<T, C, E>> entry = iterator.next();
            RouteSpecificPool<T, C, E> routeSpecificPool = entry.getValue();
            if (routeSpecificPool.getPendingCount() + routeSpecificPool.getAllocatedCount() != 0) continue;
            iterator.remove();
        }
    }

    public void closeIdle(long l, TimeUnit timeUnit) {
        Args.notNull(timeUnit, "Time unit");
        long l2 = timeUnit.toMillis(l);
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l3 = System.currentTimeMillis() - l2;
        this.enumAvailable(new AbstractConnPool$3(this, l3));
    }

    public void closeExpired() {
        long l = System.currentTimeMillis();
        this.enumAvailable(new AbstractConnPool$4(this, l));
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(int n) {
        this.validateAfterInactivity = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(this.leased);
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available);
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ Lock access$000(AbstractConnPool abstractConnPool) {
        return abstractConnPool.lock;
    }

    static /* synthetic */ Condition access$100(AbstractConnPool abstractConnPool) {
        return abstractConnPool.condition;
    }

    static /* synthetic */ PoolEntry access$200(AbstractConnPool abstractConnPool, Object object, Object object2, long l, TimeUnit timeUnit, Future future) {
        return abstractConnPool.getPoolEntryBlocking(object, object2, l, timeUnit, future);
    }

    static /* synthetic */ int access$300(AbstractConnPool abstractConnPool) {
        return abstractConnPool.validateAfterInactivity;
    }
}

