/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;

class SSLContextBuilder$KeyManagerDelegate
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager keyManager;
    private final PrivateKeyStrategy aliasStrategy;

    SSLContextBuilder$KeyManagerDelegate(X509ExtendedKeyManager x509ExtendedKeyManager, PrivateKeyStrategy privateKeyStrategy) {
        this.keyManager = x509ExtendedKeyManager;
        this.aliasStrategy = privateKeyStrategy;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.keyManager.getClientAliases(string, principalArray);
    }

    public Map<String, PrivateKeyDetails> getClientAliasMap(String[] stringArray, Principal[] principalArray) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        for (String string : stringArray) {
            String[] stringArray2 = this.keyManager.getClientAliases(string, principalArray);
            if (stringArray2 == null) continue;
            for (String string2 : stringArray2) {
                hashMap.put(string2, new PrivateKeyDetails(string, this.keyManager.getCertificateChain(string2)));
            }
        }
        return hashMap;
    }

    public Map<String, PrivateKeyDetails> getServerAliasMap(String string, Principal[] principalArray) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        String[] stringArray = this.keyManager.getServerAliases(string, principalArray);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                hashMap.put(string2, new PrivateKeyDetails(string, this.keyManager.getCertificateChain(string2)));
            }
        }
        return hashMap;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        Map<String, PrivateKeyDetails> map = this.getClientAliasMap(stringArray, principalArray);
        return this.aliasStrategy.chooseAlias(map, socket);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.keyManager.getServerAliases(string, principalArray);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        Map<String, PrivateKeyDetails> map = this.getServerAliasMap(string, principalArray);
        return this.aliasStrategy.chooseAlias(map, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this.keyManager.getCertificateChain(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.keyManager.getPrivateKey(string);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        Map<String, PrivateKeyDetails> map = this.getClientAliasMap(stringArray, principalArray);
        return this.aliasStrategy.chooseAlias(map, null);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        Map<String, PrivateKeyDetails> map = this.getServerAliasMap(string, principalArray);
        return this.aliasStrategy.chooseAlias(map, null);
    }
}

