/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractMessageLite$Builder$LimitedInputStream;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageLite$Builder<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends AbstractMessageLite$Builder<MessageType, BuilderType>>
implements MessageLite$Builder {
    public abstract BuilderType clone();

    public BuilderType mergeFrom(CodedInputStream codedInputStream) {
        return (BuilderType)this.mergeFrom(codedInputStream, ExtensionRegistryLite.getEmptyRegistry());
    }

    public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2);

    public BuilderType mergeFrom(ByteString byteString) {
        try {
            CodedInputStream codedInputStream = byteString.newCodedInput();
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
        }
    }

    public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
        try {
            CodedInputStream codedInputStream = byteString.newCodedInput();
            this.mergeFrom(codedInputStream, extensionRegistryLite);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), iOException);
        }
    }

    public BuilderType mergeFrom(byte[] byArray) {
        return (BuilderType)this.mergeFrom(byArray, 0, byArray.length);
    }

    public BuilderType mergeFrom(byte[] byArray, int n, int n2) {
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
        }
    }

    public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) {
        return (BuilderType)this.mergeFrom(byArray, 0, byArray.length, extensionRegistryLite);
    }

    public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) {
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
            this.mergeFrom(codedInputStream, extensionRegistryLite);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getReadingExceptionMessage("byte array"), iOException);
        }
    }

    public BuilderType mergeFrom(InputStream inputStream) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
        this.mergeFrom(codedInputStream);
        codedInputStream.checkLastTagWas(0);
        return (BuilderType)this;
    }

    public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
        this.mergeFrom(codedInputStream, extensionRegistryLite);
        codedInputStream.checkLastTagWas(0);
        return (BuilderType)this;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        int n = inputStream.read();
        if (n == -1) {
            return false;
        }
        int n2 = CodedInputStream.readRawVarint32(n, inputStream);
        AbstractMessageLite$Builder$LimitedInputStream abstractMessageLite$Builder$LimitedInputStream = new AbstractMessageLite$Builder$LimitedInputStream(inputStream, n2);
        this.mergeFrom(abstractMessageLite$Builder$LimitedInputStream, extensionRegistryLite);
        return true;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream inputStream) {
        return this.mergeDelimitedFrom(inputStream, ExtensionRegistryLite.getEmptyRegistry());
    }

    public BuilderType mergeFrom(MessageLite messageLite) {
        if (!this.getDefaultInstanceForType().getClass().isInstance(messageLite)) {
            throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
        }
        return this.internalMergeFrom((AbstractMessageLite)messageLite);
    }

    protected abstract BuilderType internalMergeFrom(MessageType var1);

    private String getReadingExceptionMessage(String string) {
        String string2 = String.valueOf(String.valueOf(this.getClass().getName()));
        String string3 = String.valueOf(String.valueOf(string));
        return new StringBuilder(60 + string2.length() + string3.length()).append("Reading ").append(string2).append(" from a ").append(string3).append(" threw an IOException (should never happen).").toString();
    }

    private static <T> void addAllCheckingNulls(Iterable<T> iterable, List<? super T> list) {
        if (list instanceof ArrayList && iterable instanceof Collection) {
            ((ArrayList)list).ensureCapacity(list.size() + ((Collection)iterable).size());
        }
        int n = list.size();
        for (T t : iterable) {
            if (t == null) {
                int n2 = list.size() - n;
                String string = new StringBuilder(37).append("Element at index ").append(n2).append(" is null.").toString();
                for (int i = list.size() - 1; i >= n; --i) {
                    list.remove(i);
                }
                throw new NullPointerException(string);
            }
            list.add(t);
        }
    }

    protected static UninitializedMessageException newUninitializedMessageException(MessageLite messageLite) {
        return new UninitializedMessageException(messageLite);
    }

    @Deprecated
    protected static <T> void addAll(Iterable<T> iterable, Collection<? super T> collection) {
        AbstractMessageLite$Builder.addAll(iterable, (List)collection);
    }

    protected static <T> void addAll(Iterable<T> iterable, List<? super T> list) {
        Internal.checkNotNull(iterable);
        if (iterable instanceof LazyStringList) {
            List<?> list2 = ((LazyStringList)iterable).getUnderlyingElements();
            LazyStringList lazyStringList = (LazyStringList)list;
            int n = list.size();
            for (Object obj : list2) {
                if (obj == null) {
                    int n2 = lazyStringList.size() - n;
                    String string = new StringBuilder(37).append("Element at index ").append(n2).append(" is null.").toString();
                    for (int i = lazyStringList.size() - 1; i >= n; --i) {
                        lazyStringList.remove(i);
                    }
                    throw new NullPointerException(string);
                }
                if (obj instanceof ByteString) {
                    lazyStringList.add((ByteString)obj);
                    continue;
                }
                lazyStringList.add((String)obj);
            }
        } else if (iterable instanceof PrimitiveNonBoxingCollection) {
            list.addAll((Collection)iterable);
        } else {
            AbstractMessageLite$Builder.addAllCheckingNulls(iterable, list);
        }
    }
}

