/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$BoundedByteString;
import com.google.protobuf.ByteString$LeafByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

class ByteString$LiteralByteString
extends ByteString$LeafByteString {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;

    ByteString$LiteralByteString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.bytes = byArray;
    }

    @Override
    public byte byteAt(int n) {
        return this.bytes[n];
    }

    @Override
    byte internalByteAt(int n) {
        return this.bytes[n];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public final ByteString substring(int n, int n2) {
        int n3 = ByteString$LiteralByteString.checkRange(n, n2, this.size());
        if (n3 == 0) {
            return ByteString.EMPTY;
        }
        return new ByteString$BoundedByteString(this.bytes, this.getOffsetIntoBytes() + n, n3);
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    @Override
    public final void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
    }

    @Override
    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    public final void writeTo(OutputStream outputStream) {
        outputStream.write(this.toByteArray());
    }

    @Override
    final void writeToInternal(OutputStream outputStream, int n, int n2) {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + n, n2);
    }

    @Override
    final void writeTo(ByteOutput byteOutput) {
        byteOutput.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    protected final String toStringInternal(Charset charset) {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
    }

    @Override
    public final boolean isValidUtf8() {
        int n = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8(this.bytes, n, n + this.size());
    }

    @Override
    protected final int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = this.getOffsetIntoBytes() + n2;
        return Utf8.partialIsValidUtf8(n, this.bytes, n4, n4 + n3);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)object).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (object instanceof ByteString$LiteralByteString) {
            ByteString$LiteralByteString byteString$LiteralByteString = (ByteString$LiteralByteString)object;
            int n = this.peekCachedHashCode();
            int n2 = byteString$LiteralByteString.peekCachedHashCode();
            if (n != 0 && n2 != 0 && n != n2) {
                return false;
            }
            return this.equalsRange((ByteString$LiteralByteString)object, 0, this.size());
        }
        return object.equals(this);
    }

    @Override
    final boolean equalsRange(ByteString byteString, int n, int n2) {
        if (n2 > byteString.size()) {
            int n3 = n2;
            int n4 = this.size();
            throw new IllegalArgumentException(new StringBuilder(40).append("Length too large: ").append(n3).append(n4).toString());
        }
        if (n + n2 > byteString.size()) {
            int n5 = n;
            int n6 = n2;
            int n7 = byteString.size();
            throw new IllegalArgumentException(new StringBuilder(59).append("Ran off end of other: ").append(n5).append(", ").append(n6).append(", ").append(n7).toString());
        }
        if (byteString instanceof ByteString$LiteralByteString) {
            ByteString$LiteralByteString byteString$LiteralByteString = (ByteString$LiteralByteString)byteString;
            byte[] byArray = this.bytes;
            byte[] byArray2 = byteString$LiteralByteString.bytes;
            int n8 = this.getOffsetIntoBytes() + n2;
            int n9 = this.getOffsetIntoBytes();
            int n10 = byteString$LiteralByteString.getOffsetIntoBytes() + n;
            while (n9 < n8) {
                if (byArray[n9] != byArray2[n10]) {
                    return false;
                }
                ++n9;
                ++n10;
            }
            return true;
        }
        return byteString.substring(n, n + n2).equals(this.substring(0, n2));
    }

    @Override
    protected final int partialHash(int n, int n2, int n3) {
        return Internal.partialHash(n, this.bytes, this.getOffsetIntoBytes() + n2, n3);
    }

    @Override
    public final InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size(), true);
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }
}

