/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString$1;
import com.google.protobuf.ByteString$2;
import com.google.protobuf.ByteString$ArraysByteArrayCopier;
import com.google.protobuf.ByteString$BoundedByteString;
import com.google.protobuf.ByteString$ByteArrayCopier;
import com.google.protobuf.ByteString$ByteIterator;
import com.google.protobuf.ByteString$CodedBuilder;
import com.google.protobuf.ByteString$LiteralByteString;
import com.google.protobuf.ByteString$Output;
import com.google.protobuf.ByteString$SystemByteArrayCopier;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.NioByteString;
import com.google.protobuf.RopeByteString;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new ByteString$LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteString$ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new ByteString$SystemByteArrayCopier(null) : new ByteString$ArraysByteArrayCopier(null);
    private int hash = 0;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new ByteString$2();

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public ByteString$ByteIterator iterator() {
        return new ByteString$1(this);
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private static int toInt(byte by) {
        return by & 0xFF;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    }

    public final ByteString substring(int n) {
        return this.substring(n, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public final boolean startsWith(ByteString byteString) {
        return this.size() >= byteString.size() && this.substring(0, byteString.size()).equals(byteString);
    }

    public final boolean endsWith(ByteString byteString) {
        return this.size() >= byteString.size() && this.substring(this.size() - byteString.size()).equals(byteString);
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        ByteString.checkRange(n, n + n2, byArray.length);
        return new ByteString$LiteralByteString(byteArrayCopier.copyFrom(byArray, n, n2));
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    static ByteString wrap(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            return ByteString.wrap(byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
        }
        return new NioByteString(byteBuffer);
    }

    static ByteString wrap(byte[] byArray) {
        return new ByteString$LiteralByteString(byArray);
    }

    static ByteString wrap(byte[] byArray, int n, int n2) {
        return new ByteString$BoundedByteString(byArray, n, n2);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer, int n) {
        ByteString.checkRange(0, n, byteBuffer.remaining());
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new ByteString$LiteralByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String string, String string2) {
        return new ByteString$LiteralByteString(string.getBytes(string2));
    }

    public static ByteString copyFrom(String string, Charset charset) {
        return new ByteString$LiteralByteString(string.getBytes(charset));
    }

    public static ByteString copyFromUtf8(String string) {
        return new ByteString$LiteralByteString(string.getBytes(Internal.UTF_8));
    }

    public static ByteString readFrom(InputStream inputStream) {
        return ByteString.readFrom(inputStream, 256, 8192);
    }

    public static ByteString readFrom(InputStream inputStream, int n) {
        return ByteString.readFrom(inputStream, n, n);
    }

    public static ByteString readFrom(InputStream inputStream, int n, int n2) {
        ByteString byteString;
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        int n3 = n;
        while ((byteString = ByteString.readChunk(inputStream, n3)) != null) {
            arrayList.add(byteString);
            n3 = Math.min(n3 * 2, n2);
        }
        return ByteString.copyFrom(arrayList);
    }

    private static ByteString readChunk(InputStream inputStream, int n) {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 == 0) {
            return null;
        }
        return ByteString.copyFrom(byArray, 0, n2);
    }

    public final ByteString concat(ByteString byteString) {
        if (Integer.MAX_VALUE - this.size() < byteString.size()) {
            int n = this.size();
            int n2 = byteString.size();
            throw new IllegalArgumentException(new StringBuilder(53).append("ByteString would be too long: ").append(n).append("+").append(n2).toString());
        }
        return RopeByteString.concatenate(this, byteString);
    }

    public static ByteString copyFrom(Iterable<ByteString> iterable) {
        int n;
        if (!(iterable instanceof Collection)) {
            int n2 = 0;
            Iterator<ByteString> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n2;
            }
            n = n2;
        } else {
            n = ((Collection)iterable).size();
        }
        if (n == 0) {
            return EMPTY;
        }
        return ByteString.balancedConcat(iterable.iterator(), n);
    }

    private static ByteString balancedConcat(Iterator<ByteString> iterator, int n) {
        ByteString byteString;
        if (n < 1) {
            throw new IllegalArgumentException(String.format("length (%s) must be >= 1", n));
        }
        if (n == 1) {
            byteString = iterator.next();
        } else {
            int n2 = n >>> 1;
            ByteString byteString2 = ByteString.balancedConcat(iterator, n2);
            ByteString byteString3 = ByteString.balancedConcat(iterator, n - n2);
            byteString = byteString2.concat(byteString3);
        }
        return byteString;
    }

    public void copyTo(byte[] byArray, int n) {
        this.copyTo(byArray, 0, n, this.size());
    }

    @Deprecated
    public final void copyTo(byte[] byArray, int n, int n2, int n3) {
        ByteString.checkRange(n, n + n3, this.size());
        ByteString.checkRange(n2, n2 + n3, byArray.length);
        if (n3 > 0) {
            this.copyToInternal(byArray, n, n2, n3);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public final byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        this.copyToInternal(byArray, 0, 0, n);
        return byArray;
    }

    public abstract void writeTo(OutputStream var1);

    final void writeTo(OutputStream outputStream, int n, int n2) {
        ByteString.checkRange(n, n + n2, this.size());
        if (n2 > 0) {
            this.writeToInternal(outputStream, n, n2);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3);

    abstract void writeTo(ByteOutput var1);

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    public final String toString(String string) {
        try {
            return this.toString(Charset.forName(string));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
            unsupportedEncodingException.initCause(unsupportedCharsetException);
            throw unsupportedEncodingException;
        }
    }

    public final String toString(Charset charset) {
        return this.size() == 0 ? "" : this.toStringInternal(charset);
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = this.size();
            n = this.partialHash(n2, 0, n2);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static ByteString$Output newOutput(int n) {
        return new ByteString$Output(n);
    }

    public static ByteString$Output newOutput() {
        return new ByteString$Output(128);
    }

    static ByteString$CodedBuilder newCodedBuilder(int n) {
        return new ByteString$CodedBuilder(n, null);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    static void checkIndex(int n, int n2) {
        if ((n | n2 - (n + 1)) < 0) {
            if (n < 0) {
                int n3 = n;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(22).append("Index < 0: ").append(n3).toString());
            }
            int n4 = n;
            int n5 = n2;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(40).append("Index > length: ").append(n4).append(", ").append(n5).toString());
        }
    }

    static int checkRange(int n, int n2, int n3) {
        int n4 = n2 - n;
        if ((n | n2 | n4 | n3 - n2) < 0) {
            if (n < 0) {
                int n5 = n;
                throw new IndexOutOfBoundsException(new StringBuilder(32).append("Beginning index: ").append(n5).append(" < 0").toString());
            }
            if (n2 < n) {
                int n6 = n;
                int n7 = n2;
                throw new IndexOutOfBoundsException(new StringBuilder(66).append("Beginning index larger than ending index: ").append(n6).append(", ").append(n7).toString());
            }
            int n8 = n2;
            int n9 = n3;
            throw new IndexOutOfBoundsException(new StringBuilder(37).append("End index: ").append(n8).append(" >= ").append(n9).toString());
        }
        return n4;
    }

    public final String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    static /* synthetic */ int access$200(byte by) {
        return ByteString.toInt(by);
    }
}

