/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedInputStream$1;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;
import java.util.Iterator;

final class CodedInputStream$IterableDirectByteBufferDecoder
extends CodedInputStream {
    private Iterable<ByteBuffer> input;
    private Iterator<ByteBuffer> iterator;
    private ByteBuffer currentByteBuffer;
    private boolean immutable;
    private boolean enableAliasing;
    private int totalBufferSize;
    private int bufferSizeAfterCurrentLimit;
    private int currentLimit = Integer.MAX_VALUE;
    private int lastTag;
    private int totalBytesRead;
    private int startOffset;
    private long currentByteBufferPos;
    private long currentByteBufferStartPos;
    private long currentAddress;
    private long currentByteBufferLimit;

    private CodedInputStream$IterableDirectByteBufferDecoder(Iterable<ByteBuffer> iterable, int n, boolean bl) {
        super(null);
        this.totalBufferSize = n;
        this.input = iterable;
        this.iterator = this.input.iterator();
        this.immutable = bl;
        this.totalBytesRead = 0;
        this.startOffset = 0;
        if (n == 0) {
            this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
            this.currentByteBufferPos = 0L;
            this.currentByteBufferStartPos = 0L;
            this.currentByteBufferLimit = 0L;
            this.currentAddress = 0L;
        } else {
            this.tryGetNextByteBuffer();
        }
    }

    private void getNextByteBuffer() {
        if (!this.iterator.hasNext()) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.tryGetNextByteBuffer();
    }

    private void tryGetNextByteBuffer() {
        this.currentByteBuffer = this.iterator.next();
        this.totalBytesRead += (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
        this.currentByteBufferStartPos = this.currentByteBufferPos = (long)this.currentByteBuffer.position();
        this.currentByteBufferLimit = this.currentByteBuffer.limit();
        this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
        this.currentByteBufferPos += this.currentAddress;
        this.currentByteBufferStartPos += this.currentAddress;
        this.currentByteBufferLimit += this.currentAddress;
    }

    @Override
    public int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    @Override
    public void checkLastTagWas(int n) {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    @Override
    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public boolean skipField(int n) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                long l = this.readInt64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeUInt64NoTag(l);
                return true;
            }
            case 1: {
                long l = this.readRawLittleEndian64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed64NoTag(l);
                return true;
            }
            case 2: {
                ByteString byteString = this.readBytes();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeBytesNoTag(byteString);
                return true;
            }
            case 3: {
                codedOutputStream.writeRawVarint32(n);
                this.skipMessage(codedOutputStream);
                int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                this.checkLastTagWas(n2);
                codedOutputStream.writeRawVarint32(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                int n3 = this.readRawLittleEndian32();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed32NoTag(n3);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public void skipMessage() {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    @Override
    public void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() {
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() {
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() {
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    @Override
    public String readString() {
        int n = this.readRawVarint32();
        if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
            String string = new String(byArray, Internal.UTF_8);
            this.currentByteBufferPos += (long)n;
            return string;
        }
        if (n > 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.readRawBytesTo(byArray, 0, n);
            String string = new String(byArray, Internal.UTF_8);
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public String readStringRequireUtf8() {
        int n = this.readRawVarint32();
        if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
            int n2 = (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
            String string = Utf8.decodeUtf8(this.currentByteBuffer, n2, n);
            this.currentByteBufferPos += (long)n;
            return string;
        }
        if (n >= 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.readRawBytesTo(byArray, 0, n);
            return Utf8.decodeUtf8(byArray, 0, n);
        }
        if (n == 0) {
            return "";
        }
        if (n <= 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void readGroup(int n, MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    @Override
    public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
        return (T)messageLite;
    }

    @Override
    @Deprecated
    public void readUnknownGroup(int n, MessageLite$Builder messageLite$Builder) {
        this.readGroup(n, messageLite$Builder, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void readMessage(MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    @Override
    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
        return (T)messageLite;
    }

    @Override
    public ByteString readBytes() {
        int n = this.readRawVarint32();
        if (n > 0 && (long)n <= this.currentByteBufferLimit - this.currentByteBufferPos) {
            if (this.immutable && this.enableAliasing) {
                int n2 = (int)(this.currentByteBufferPos - this.currentAddress);
                ByteString byteString = ByteString.wrap(this.slice(n2, n2 + n));
                this.currentByteBufferPos += (long)n;
                return byteString;
            }
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
            this.currentByteBufferPos += (long)n;
            return ByteString.wrap(byArray);
        }
        if (n > 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.readRawBytesTo(byArray, 0, n);
            return ByteString.wrap(byArray);
        }
        if (n == 0) {
            return ByteString.EMPTY;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public byte[] readByteArray() {
        return this.readRawBytes(this.readRawVarint32());
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int n = this.readRawVarint32();
        if (n > 0 && (long)n <= this.currentRemaining()) {
            if (!this.immutable && this.enableAliasing) {
                this.currentByteBufferPos += (long)n;
                return this.slice((int)(this.currentByteBufferPos - this.currentAddress - (long)n), (int)(this.currentByteBufferPos - this.currentAddress));
            }
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
            this.currentByteBufferPos += (long)n;
            return ByteBuffer.wrap(byArray);
        }
        if (n > 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.readRawBytesTo(byArray, 0, n);
            return ByteBuffer.wrap(byArray);
        }
        if (n == 0) {
            return Internal.EMPTY_BYTE_BUFFER;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public int readUInt32() {
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() {
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() {
        return CodedInputStream$IterableDirectByteBufferDecoder.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() {
        return CodedInputStream$IterableDirectByteBufferDecoder.decodeZigZag64(this.readRawVarint64());
    }

    @Override
    public int readRawVarint32() {
        block4: {
            int n;
            long l;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            l = this.currentByteBufferPos;
                            if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                            if ((n = UnsafeUtil.getByte(l++)) >= 0) {
                                ++this.currentByteBufferPos;
                                return n;
                            }
                            if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                            if ((n ^= UnsafeUtil.getByte(l++) << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= UnsafeUtil.getByte(l++) << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= UnsafeUtil.getByte(l++) << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = UnsafeUtil.getByte(l++);
                n ^= by << 28;
                n ^= 0xFE03F80;
                if (by < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0) break block4;
            }
            this.currentByteBufferPos = l;
            return n;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    @Override
    public long readRawVarint64() {
        block4: {
            long l;
            long l2;
            block6: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n;
                                block8: {
                                    block7: {
                                        block5: {
                                            l2 = this.currentByteBufferPos;
                                            if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                            if ((n = UnsafeUtil.getByte(l2++)) >= 0) {
                                                ++this.currentByteBufferPos;
                                                return n;
                                            }
                                            if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                            if ((n ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                            l = n ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                                        l = n ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                                    l = n ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n ^ (long)UnsafeUtil.getByte(l2++) << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)UnsafeUtil.getByte(l2++) << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)UnsafeUtil.getByte(l2++) << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)UnsafeUtil.getByte(l2++) << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                l ^= (long)UnsafeUtil.getByte(l2++) << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l2++) < 0L) break block4;
            }
            this.currentByteBufferPos = l2;
            return l;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public int readRawLittleEndian32() {
        if (this.currentRemaining() >= 4L) {
            long l = this.currentByteBufferPos;
            this.currentByteBufferPos += 4L;
            return UnsafeUtil.getByte(l) & 0xFF | (UnsafeUtil.getByte(l + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l + 3L) & 0xFF) << 24;
        }
        return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
    }

    @Override
    public long readRawLittleEndian64() {
        if (this.currentRemaining() >= 8L) {
            long l = this.currentByteBufferPos;
            this.currentByteBufferPos += 8L;
            return (long)UnsafeUtil.getByte(l) & 0xFFL | ((long)UnsafeUtil.getByte(l + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l + 7L) & 0xFFL) << 56;
        }
        return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
    }

    @Override
    public void enableAliasing(boolean bl) {
        this.enableAliasing = bl;
    }

    @Override
    public void resetSizeCounter() {
        this.startOffset = (int)((long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos);
    }

    @Override
    public int pushLimit(int n) {
        int n2;
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.totalBufferSize += this.bufferSizeAfterCurrentLimit;
        int n = this.totalBufferSize - this.startOffset;
        if (n > this.currentLimit) {
            this.bufferSizeAfterCurrentLimit = n - this.currentLimit;
            this.totalBufferSize -= this.bufferSizeAfterCurrentLimit;
        } else {
            this.bufferSizeAfterCurrentLimit = 0;
        }
    }

    @Override
    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    @Override
    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        return this.currentLimit - this.getTotalBytesRead();
    }

    @Override
    public boolean isAtEnd() {
        return (long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos == (long)this.totalBufferSize;
    }

    @Override
    public int getTotalBytesRead() {
        return (int)((long)(this.totalBytesRead - this.startOffset) + this.currentByteBufferPos - this.currentByteBufferStartPos);
    }

    @Override
    public byte readRawByte() {
        if (this.currentRemaining() == 0L) {
            this.getNextByteBuffer();
        }
        return UnsafeUtil.getByte(this.currentByteBufferPos++);
    }

    @Override
    public byte[] readRawBytes(int n) {
        if (n >= 0 && (long)n <= this.currentRemaining()) {
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n);
            this.currentByteBufferPos += (long)n;
            return byArray;
        }
        if (n >= 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.readRawBytesTo(byArray, 0, n);
            return byArray;
        }
        if (n <= 0) {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    private void readRawBytesTo(byte[] byArray, int n, int n2) {
        if (n2 >= 0 && n2 <= this.remaining()) {
            int n3 = n2;
            while (n3 > 0) {
                if (this.currentRemaining() == 0L) {
                    this.getNextByteBuffer();
                }
                int n4 = Math.min(n3, (int)this.currentRemaining());
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, (long)(n2 - n3 + n), (long)n4);
                n3 -= n4;
                this.currentByteBufferPos += (long)n4;
            }
            return;
        }
        if (n2 <= 0) {
            if (n2 == 0) {
                return;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void skipRawBytes(int n) {
        if (n >= 0 && (long)n <= (long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos) {
            int n2 = n;
            while (n2 > 0) {
                if (this.currentRemaining() == 0L) {
                    this.getNextByteBuffer();
                }
                int n3 = Math.min(n2, (int)this.currentRemaining());
                n2 -= n3;
                this.currentByteBufferPos += (long)n3;
            }
            return;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    private void skipRawVarint() {
        for (int i = 0; i < 10; ++i) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    private int remaining() {
        return (int)((long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos);
    }

    private long currentRemaining() {
        return this.currentByteBufferLimit - this.currentByteBufferPos;
    }

    private ByteBuffer slice(int n, int n2) {
        int n3 = this.currentByteBuffer.position();
        int n4 = this.currentByteBuffer.limit();
        try {
            this.currentByteBuffer.position(n);
            this.currentByteBuffer.limit(n2);
            ByteBuffer byteBuffer = this.currentByteBuffer.slice();
            return byteBuffer;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        finally {
            this.currentByteBuffer.position(n3);
            this.currentByteBuffer.limit(n4);
        }
    }

    /* synthetic */ CodedInputStream$IterableDirectByteBufferDecoder(Iterable iterable, int n, boolean bl, CodedInputStream$1 codedInputStream$1) {
        this(iterable, n, bl);
    }
}

