/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedInputStream$1;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;

final class CodedInputStream$UnsafeDirectNioDecoder
extends CodedInputStream {
    private final ByteBuffer buffer;
    private final boolean immutable;
    private final long address;
    private long limit;
    private long pos;
    private long startPos;
    private int bufferSizeAfterLimit;
    private int lastTag;
    private boolean enableAliasing;
    private int currentLimit = Integer.MAX_VALUE;

    static boolean isSupported() {
        return UnsafeUtil.hasUnsafeByteBufferOperations();
    }

    private CodedInputStream$UnsafeDirectNioDecoder(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.buffer = byteBuffer;
        this.address = UnsafeUtil.addressOffset(byteBuffer);
        this.limit = this.address + (long)byteBuffer.limit();
        this.startPos = this.pos = this.address + (long)byteBuffer.position();
        this.immutable = bl;
    }

    @Override
    public int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    @Override
    public void checkLastTagWas(int n) {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    @Override
    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public boolean skipField(int n) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                long l = this.readInt64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeUInt64NoTag(l);
                return true;
            }
            case 1: {
                long l = this.readRawLittleEndian64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed64NoTag(l);
                return true;
            }
            case 2: {
                ByteString byteString = this.readBytes();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeBytesNoTag(byteString);
                return true;
            }
            case 3: {
                codedOutputStream.writeRawVarint32(n);
                this.skipMessage(codedOutputStream);
                int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                this.checkLastTagWas(n2);
                codedOutputStream.writeRawVarint32(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                int n3 = this.readRawLittleEndian32();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed32NoTag(n3);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public void skipMessage() {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    @Override
    public void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() {
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() {
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() {
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    @Override
    public String readString() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
            String string = new String(byArray, Internal.UTF_8);
            this.pos += (long)n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public String readStringRequireUtf8() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.remaining()) {
            int n2 = this.bufferPos(this.pos);
            String string = Utf8.decodeUtf8(this.buffer, n2, n);
            this.pos += (long)n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n <= 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void readGroup(int n, MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    @Override
    public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
        return (T)messageLite;
    }

    @Override
    @Deprecated
    public void readUnknownGroup(int n, MessageLite$Builder messageLite$Builder) {
        this.readGroup(n, messageLite$Builder, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void readMessage(MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    @Override
    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
        return (T)messageLite;
    }

    @Override
    public ByteString readBytes() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.remaining()) {
            if (this.immutable && this.enableAliasing) {
                ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n);
                this.pos += (long)n;
                return ByteString.wrap(byteBuffer);
            }
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
            this.pos += (long)n;
            return ByteString.wrap(byArray);
        }
        if (n == 0) {
            return ByteString.EMPTY;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public byte[] readByteArray() {
        return this.readRawBytes(this.readRawVarint32());
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.remaining()) {
            if (!this.immutable && this.enableAliasing) {
                ByteBuffer byteBuffer = this.slice(this.pos, this.pos + (long)n);
                this.pos += (long)n;
                return byteBuffer;
            }
            byte[] byArray = new byte[n];
            UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n);
            this.pos += (long)n;
            return ByteBuffer.wrap(byArray);
        }
        if (n == 0) {
            return Internal.EMPTY_BYTE_BUFFER;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public int readUInt32() {
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() {
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() {
        return CodedInputStream$UnsafeDirectNioDecoder.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() {
        return CodedInputStream$UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
    }

    @Override
    public int readRawVarint32() {
        block4: {
            int n;
            long l;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            l = this.pos;
                            if (this.limit == l) break block4;
                            if ((n = UnsafeUtil.getByte(l++)) >= 0) {
                                this.pos = l;
                                return n;
                            }
                            if (this.limit - l < 9L) break block4;
                            if ((n ^= UnsafeUtil.getByte(l++) << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= UnsafeUtil.getByte(l++) << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= UnsafeUtil.getByte(l++) << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = UnsafeUtil.getByte(l++);
                n ^= by << 28;
                n ^= 0xFE03F80;
                if (by < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0 && UnsafeUtil.getByte(l++) < 0) break block4;
            }
            this.pos = l;
            return n;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private void skipRawVarint() {
        if (this.remaining() >= 10) {
            this.skipRawVarintFastPath();
        } else {
            this.skipRawVarintSlowPath();
        }
    }

    private void skipRawVarintFastPath() {
        for (int i = 0; i < 10; ++i) {
            if (UnsafeUtil.getByte(this.pos++) < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    private void skipRawVarintSlowPath() {
        for (int i = 0; i < 10; ++i) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public long readRawVarint64() {
        block4: {
            long l;
            long l2;
            block6: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n;
                                block8: {
                                    block7: {
                                        block5: {
                                            l2 = this.pos;
                                            if (this.limit == l2) break block4;
                                            if ((n = UnsafeUtil.getByte(l2++)) >= 0) {
                                                this.pos = l2;
                                                return n;
                                            }
                                            if (this.limit - l2 < 9L) break block4;
                                            if ((n ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                            l = n ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                                        l = n ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                                    l = n ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n ^ (long)UnsafeUtil.getByte(l2++) << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)UnsafeUtil.getByte(l2++) << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)UnsafeUtil.getByte(l2++) << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)UnsafeUtil.getByte(l2++) << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                l ^= (long)UnsafeUtil.getByte(l2++) << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l2++) < 0L) break block4;
            }
            this.pos = l2;
            return l;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public int readRawLittleEndian32() {
        long l = this.pos;
        if (this.limit - l < 4L) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.pos = l + 4L;
        return UnsafeUtil.getByte(l) & 0xFF | (UnsafeUtil.getByte(l + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l + 3L) & 0xFF) << 24;
    }

    @Override
    public long readRawLittleEndian64() {
        long l = this.pos;
        if (this.limit - l < 8L) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.pos = l + 8L;
        return (long)UnsafeUtil.getByte(l) & 0xFFL | ((long)UnsafeUtil.getByte(l + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l + 7L) & 0xFFL) << 56;
    }

    @Override
    public void enableAliasing(boolean bl) {
        this.enableAliasing = bl;
    }

    @Override
    public void resetSizeCounter() {
        this.startPos = this.pos;
    }

    @Override
    public int pushLimit(int n) {
        int n2;
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    @Override
    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    @Override
    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        return this.currentLimit - this.getTotalBytesRead();
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.limit;
    }

    @Override
    public int getTotalBytesRead() {
        return (int)(this.pos - this.startPos);
    }

    @Override
    public byte readRawByte() {
        if (this.pos == this.limit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return UnsafeUtil.getByte(this.pos++);
    }

    @Override
    public byte[] readRawBytes(int n) {
        if (n >= 0 && n <= this.remaining()) {
            byte[] byArray = new byte[n];
            this.slice(this.pos, this.pos + (long)n).get(byArray);
            this.pos += (long)n;
            return byArray;
        }
        if (n <= 0) {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void skipRawBytes(int n) {
        if (n >= 0 && n <= this.remaining()) {
            this.pos += (long)n;
            return;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    private void recomputeBufferSizeAfterLimit() {
        this.limit += (long)this.bufferSizeAfterLimit;
        int n = (int)(this.limit - this.startPos);
        if (n > this.currentLimit) {
            this.bufferSizeAfterLimit = n - this.currentLimit;
            this.limit -= (long)this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    private int remaining() {
        return (int)(this.limit - this.pos);
    }

    private int bufferPos(long l) {
        return (int)(l - this.address);
    }

    private ByteBuffer slice(long l, long l2) {
        int n = this.buffer.position();
        int n2 = this.buffer.limit();
        try {
            this.buffer.position(this.bufferPos(l));
            this.buffer.limit(this.bufferPos(l2));
            ByteBuffer byteBuffer = this.buffer.slice();
            return byteBuffer;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        finally {
            this.buffer.position(n);
            this.buffer.limit(n2);
        }
    }

    /* synthetic */ CodedInputStream$UnsafeDirectNioDecoder(ByteBuffer byteBuffer, boolean bl, CodedInputStream$1 codedInputStream$1) {
        this(byteBuffer, bl);
    }
}

