/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream$1;
import com.google.protobuf.CodedInputStream$ArrayDecoder;
import com.google.protobuf.CodedInputStream$IterableDirectByteBufferDecoder;
import com.google.protobuf.CodedInputStream$StreamDecoder;
import com.google.protobuf.CodedInputStream$UnsafeDirectNioDecoder;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.IterableByteBufferInputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.Parser;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class CodedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_RECURSION_LIMIT = 100;
    private static final int DEFAULT_SIZE_LIMIT = Integer.MAX_VALUE;
    int recursionDepth;
    int recursionLimit = 100;
    int sizeLimit = Integer.MAX_VALUE;
    private boolean shouldDiscardUnknownFields = false;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return CodedInputStream.newInstance(inputStream, 4096);
    }

    public static CodedInputStream newInstance(InputStream inputStream, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        if (inputStream == null) {
            return CodedInputStream.newInstance(Internal.EMPTY_BYTE_ARRAY);
        }
        return new CodedInputStream$StreamDecoder(inputStream, n, null);
    }

    public static CodedInputStream newInstance(Iterable<ByteBuffer> iterable) {
        if (!CodedInputStream$UnsafeDirectNioDecoder.isSupported()) {
            return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
        }
        return CodedInputStream.newInstance(iterable, false);
    }

    static CodedInputStream newInstance(Iterable<ByteBuffer> iterable, boolean bl) {
        int n = 0;
        int n2 = 0;
        for (ByteBuffer byteBuffer : iterable) {
            n2 += byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                n |= 1;
                continue;
            }
            if (byteBuffer.isDirect()) {
                n |= 2;
                continue;
            }
            n |= 4;
        }
        if (n == 2) {
            return new CodedInputStream$IterableDirectByteBufferDecoder(iterable, n2, bl, null);
        }
        return CodedInputStream.newInstance(new IterableByteBufferInputStream(iterable));
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n, int n2) {
        return CodedInputStream.newInstance(byArray, n, n2, false);
    }

    static CodedInputStream newInstance(byte[] byArray, int n, int n2, boolean bl) {
        CodedInputStream$ArrayDecoder codedInputStream$ArrayDecoder = new CodedInputStream$ArrayDecoder(byArray, n, n2, bl, null);
        try {
            codedInputStream$ArrayDecoder.pushLimit(n2);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return codedInputStream$ArrayDecoder;
    }

    public static CodedInputStream newInstance(ByteBuffer byteBuffer) {
        return CodedInputStream.newInstance(byteBuffer, false);
    }

    static CodedInputStream newInstance(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer.hasArray()) {
            return CodedInputStream.newInstance(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), bl);
        }
        if (byteBuffer.isDirect() && CodedInputStream$UnsafeDirectNioDecoder.isSupported()) {
            return new CodedInputStream$UnsafeDirectNioDecoder(byteBuffer, bl, null);
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(byArray);
        return CodedInputStream.newInstance(byArray, 0, byArray.length, true);
    }

    private CodedInputStream() {
    }

    public abstract int readTag();

    public abstract void checkLastTagWas(int var1);

    public abstract int getLastTag();

    public abstract boolean skipField(int var1);

    @Deprecated
    public abstract boolean skipField(int var1, CodedOutputStream var2);

    public abstract void skipMessage();

    public abstract void skipMessage(CodedOutputStream var1);

    public abstract double readDouble();

    public abstract float readFloat();

    public abstract long readUInt64();

    public abstract long readInt64();

    public abstract int readInt32();

    public abstract long readFixed64();

    public abstract int readFixed32();

    public abstract boolean readBool();

    public abstract String readString();

    public abstract String readStringRequireUtf8();

    public abstract void readGroup(int var1, MessageLite$Builder var2, ExtensionRegistryLite var3);

    public abstract <T extends MessageLite> T readGroup(int var1, Parser<T> var2, ExtensionRegistryLite var3);

    @Deprecated
    public abstract void readUnknownGroup(int var1, MessageLite$Builder var2);

    public abstract void readMessage(MessageLite$Builder var1, ExtensionRegistryLite var2);

    public abstract <T extends MessageLite> T readMessage(Parser<T> var1, ExtensionRegistryLite var2);

    public abstract ByteString readBytes();

    public abstract byte[] readByteArray();

    public abstract ByteBuffer readByteBuffer();

    public abstract int readUInt32();

    public abstract int readEnum();

    public abstract int readSFixed32();

    public abstract long readSFixed64();

    public abstract int readSInt32();

    public abstract long readSInt64();

    public abstract int readRawVarint32();

    public abstract long readRawVarint64();

    abstract long readRawVarint64SlowPath();

    public abstract int readRawLittleEndian32();

    public abstract long readRawLittleEndian64();

    public abstract void enableAliasing(boolean var1);

    public final int setRecursionLimit(int n) {
        if (n < 0) {
            int n2 = n;
            throw new IllegalArgumentException(new StringBuilder(47).append("Recursion limit cannot be negative: ").append(n2).toString());
        }
        int n3 = this.recursionLimit;
        this.recursionLimit = n;
        return n3;
    }

    public final int setSizeLimit(int n) {
        if (n < 0) {
            int n2 = n;
            throw new IllegalArgumentException(new StringBuilder(42).append("Size limit cannot be negative: ").append(n2).toString());
        }
        int n3 = this.sizeLimit;
        this.sizeLimit = n;
        return n3;
    }

    final void discardUnknownFields() {
        this.shouldDiscardUnknownFields = true;
    }

    final void unsetDiscardUnknownFields() {
        this.shouldDiscardUnknownFields = false;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public abstract void resetSizeCounter();

    public abstract int pushLimit(int var1);

    public abstract void popLimit(int var1);

    public abstract int getBytesUntilLimit();

    public abstract boolean isAtEnd();

    public abstract int getTotalBytesRead();

    public abstract byte readRawByte();

    public abstract byte[] readRawBytes(int var1);

    public abstract void skipRawBytes(int var1);

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    public static int readRawVarint32(int n, InputStream inputStream) {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        int n4 = n & 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n4 |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n4;
        }
        while (n3 < 64) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 & 0x80) == 0) {
                return n4;
            }
            n3 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    static int readRawVarint32(InputStream inputStream) {
        int n = inputStream.read();
        if (n == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n, inputStream);
    }

    /* synthetic */ CodedInputStream(CodedInputStream$1 codedInputStream$1) {
        this();
    }
}

