/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.WireFormat;

abstract class CodedOutputStream$AbstractBufferedEncoder
extends CodedOutputStream {
    final byte[] buffer;
    final int limit;
    int position;
    int totalBytesWritten;

    CodedOutputStream$AbstractBufferedEncoder(int n) {
        super(null);
        if (n < 0) {
            throw new IllegalArgumentException("bufferSize must be >= 0");
        }
        this.buffer = new byte[Math.max(n, 20)];
        this.limit = this.buffer.length;
    }

    @Override
    public final int spaceLeft() {
        throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
    }

    @Override
    public final int getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    final void buffer(byte by) {
        this.buffer[this.position++] = by;
        ++this.totalBytesWritten;
    }

    final void bufferTag(int n, int n2) {
        this.bufferUInt32NoTag(WireFormat.makeTag(n, n2));
    }

    final void bufferInt32NoTag(int n) {
        if (n >= 0) {
            this.bufferUInt32NoTag(n);
        } else {
            this.bufferUInt64NoTag(n);
        }
    }

    final void bufferUInt32NoTag(int n) {
        if (CodedOutputStream.access$100()) {
            long l = this.position;
            while (true) {
                if ((n & 0xFFFFFF80) == 0) break;
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
            int n2 = (int)((long)this.position - l);
            this.totalBytesWritten += n2;
        } else {
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)n;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                ++this.totalBytesWritten;
                n >>>= 7;
            }
        }
    }

    final void bufferUInt64NoTag(long l) {
        if (CodedOutputStream.access$100()) {
            long l2 = this.position;
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l);
            int n = (int)((long)this.position - l2);
            this.totalBytesWritten += n;
        } else {
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)l;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                ++this.totalBytesWritten;
                l >>>= 7;
            }
        }
    }

    final void bufferFixed32NoTag(int n) {
        this.buffer[this.position++] = (byte)(n & 0xFF);
        this.buffer[this.position++] = (byte)(n >> 8 & 0xFF);
        this.buffer[this.position++] = (byte)(n >> 16 & 0xFF);
        this.buffer[this.position++] = (byte)(n >> 24 & 0xFF);
        this.totalBytesWritten += 4;
    }

    final void bufferFixed64NoTag(long l) {
        this.buffer[this.position++] = (byte)(l & 0xFFL);
        this.buffer[this.position++] = (byte)(l >> 8 & 0xFFL);
        this.buffer[this.position++] = (byte)(l >> 16 & 0xFFL);
        this.buffer[this.position++] = (byte)(l >> 24 & 0xFFL);
        this.buffer[this.position++] = (byte)((int)(l >> 32) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(l >> 40) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(l >> 48) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(l >> 56) & 0xFF);
        this.totalBytesWritten += 8;
    }
}

