/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.CodedOutputStream$OutOfSpaceException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;

class CodedOutputStream$ArrayEncoder
extends CodedOutputStream {
    private final byte[] buffer;
    private final int offset;
    private final int limit;
    private int position;

    CodedOutputStream$ArrayEncoder(byte[] byArray, int n, int n2) {
        super(null);
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        if ((n | n2 | byArray.length - (n + n2)) < 0) {
            throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
        }
        this.buffer = byArray;
        this.offset = n;
        this.position = n;
        this.limit = n + n2;
    }

    @Override
    public final void writeTag(int n, int n2) {
        this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
    }

    @Override
    public final void writeInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeInt32NoTag(n2);
    }

    @Override
    public final void writeUInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeUInt32NoTag(n2);
    }

    @Override
    public final void writeFixed32(int n, int n2) {
        this.writeTag(n, 5);
        this.writeFixed32NoTag(n2);
    }

    @Override
    public final void writeUInt64(int n, long l) {
        this.writeTag(n, 0);
        this.writeUInt64NoTag(l);
    }

    @Override
    public final void writeFixed64(int n, long l) {
        this.writeTag(n, 1);
        this.writeFixed64NoTag(l);
    }

    @Override
    public final void writeBool(int n, boolean bl) {
        this.writeTag(n, 0);
        this.write((byte)(bl ? 1 : 0));
    }

    @Override
    public final void writeString(int n, String string) {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    @Override
    public final void writeBytes(int n, ByteString byteString) {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteString);
    }

    @Override
    public final void writeByteArray(int n, byte[] byArray) {
        this.writeByteArray(n, byArray, 0, byArray.length);
    }

    @Override
    public final void writeByteArray(int n, byte[] byArray, int n2, int n3) {
        this.writeTag(n, 2);
        this.writeByteArrayNoTag(byArray, n2, n3);
    }

    @Override
    public final void writeByteBuffer(int n, ByteBuffer byteBuffer) {
        this.writeTag(n, 2);
        this.writeUInt32NoTag(byteBuffer.capacity());
        this.writeRawBytes(byteBuffer);
    }

    @Override
    public final void writeBytesNoTag(ByteString byteString) {
        this.writeUInt32NoTag(byteString.size());
        byteString.writeTo(this);
    }

    @Override
    public final void writeByteArrayNoTag(byte[] byArray, int n, int n2) {
        this.writeUInt32NoTag(n2);
        this.write(byArray, n, n2);
    }

    @Override
    public final void writeRawBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        } else {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byteBuffer2.clear();
            this.write(byteBuffer2);
        }
    }

    @Override
    public final void writeMessage(int n, MessageLite messageLite) {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageLite);
    }

    @Override
    public final void writeMessageSetExtension(int n, MessageLite messageLite) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    @Override
    public final void writeRawMessageSetExtension(int n, ByteString byteString) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    @Override
    public final void writeMessageNoTag(MessageLite messageLite) {
        this.writeUInt32NoTag(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    @Override
    public final void write(byte by) {
        try {
            this.buffer[this.position++] = by;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeInt32NoTag(int n) {
        if (n >= 0) {
            this.writeUInt32NoTag(n);
        } else {
            this.writeUInt64NoTag(n);
        }
    }

    @Override
    public final void writeUInt32NoTag(int n) {
        if (CodedOutputStream.access$100() && this.spaceLeft() >= 10) {
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
        }
        try {
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)n;
                    return;
                }
                this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                n >>>= 7;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeFixed32NoTag(int n) {
        try {
            this.buffer[this.position++] = (byte)(n & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 24 & 0xFF);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeUInt64NoTag(long l) {
        if (CodedOutputStream.access$100() && this.spaceLeft() >= 10) {
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
        }
        try {
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)l;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                l >>>= 7;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeFixed64NoTag(long l) {
        try {
            this.buffer[this.position++] = (byte)((int)l & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 8) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 16) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 24) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 56) & 0xFF);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
        }
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(byArray, n, this.buffer, this.position, n2);
            this.position += n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeLazy(byte[] byArray, int n, int n2) {
        this.write(byArray, n, n2);
    }

    @Override
    public final void write(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        try {
            byteBuffer.get(this.buffer, this.position, n);
            this.position += n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n), indexOutOfBoundsException);
        }
    }

    @Override
    public final void writeLazy(ByteBuffer byteBuffer) {
        this.write(byteBuffer);
    }

    @Override
    public final void writeStringNoTag(String string) {
        int n = this.position;
        try {
            int n2 = string.length() * 3;
            int n3 = CodedOutputStream$ArrayEncoder.computeUInt32SizeNoTag(n2);
            int n4 = CodedOutputStream$ArrayEncoder.computeUInt32SizeNoTag(string.length());
            if (n4 == n3) {
                this.position = n + n4;
                int n5 = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
                this.position = n;
                int n6 = n5 - n - n4;
                this.writeUInt32NoTag(n6);
                this.position = n5;
            } else {
                int n7 = Utf8.encodedLength(string);
                this.writeUInt32NoTag(n7);
                this.position = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
            }
        }
        catch (Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
            this.position = n;
            this.inefficientWriteStringNoTag(string, utf8$UnpairedSurrogateException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public final int spaceLeft() {
        return this.limit - this.position;
    }

    @Override
    public final int getTotalBytesWritten() {
        return this.position - this.offset;
    }
}

