/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.CodedOutputStream$OutOfSpaceException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.WireFormat;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class CodedOutputStream$UnsafeDirectNioEncoder
extends CodedOutputStream {
    private final ByteBuffer originalBuffer;
    private final ByteBuffer buffer;
    private final long address;
    private final long initialPosition;
    private final long limit;
    private final long oneVarintLimit;
    private long position;

    CodedOutputStream$UnsafeDirectNioEncoder(ByteBuffer byteBuffer) {
        super(null);
        this.originalBuffer = byteBuffer;
        this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.address = UnsafeUtil.addressOffset(byteBuffer);
        this.initialPosition = this.address + (long)byteBuffer.position();
        this.limit = this.address + (long)byteBuffer.limit();
        this.oneVarintLimit = this.limit - 10L;
        this.position = this.initialPosition;
    }

    static boolean isSupported() {
        return UnsafeUtil.hasUnsafeByteBufferOperations();
    }

    @Override
    public void writeTag(int n, int n2) {
        this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
    }

    @Override
    public void writeInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeInt32NoTag(n2);
    }

    @Override
    public void writeUInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeUInt32NoTag(n2);
    }

    @Override
    public void writeFixed32(int n, int n2) {
        this.writeTag(n, 5);
        this.writeFixed32NoTag(n2);
    }

    @Override
    public void writeUInt64(int n, long l) {
        this.writeTag(n, 0);
        this.writeUInt64NoTag(l);
    }

    @Override
    public void writeFixed64(int n, long l) {
        this.writeTag(n, 1);
        this.writeFixed64NoTag(l);
    }

    @Override
    public void writeBool(int n, boolean bl) {
        this.writeTag(n, 0);
        this.write((byte)(bl ? 1 : 0));
    }

    @Override
    public void writeString(int n, String string) {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    @Override
    public void writeBytes(int n, ByteString byteString) {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteString);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray) {
        this.writeByteArray(n, byArray, 0, byArray.length);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray, int n2, int n3) {
        this.writeTag(n, 2);
        this.writeByteArrayNoTag(byArray, n2, n3);
    }

    @Override
    public void writeByteBuffer(int n, ByteBuffer byteBuffer) {
        this.writeTag(n, 2);
        this.writeUInt32NoTag(byteBuffer.capacity());
        this.writeRawBytes(byteBuffer);
    }

    @Override
    public void writeMessage(int n, MessageLite messageLite) {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageLite);
    }

    @Override
    public void writeMessageSetExtension(int n, MessageLite messageLite) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    @Override
    public void writeRawMessageSetExtension(int n, ByteString byteString) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    @Override
    public void writeMessageNoTag(MessageLite messageLite) {
        this.writeUInt32NoTag(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    @Override
    public void write(byte by) {
        if (this.position >= this.limit) {
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }
        UnsafeUtil.putByte(this.position++, by);
    }

    @Override
    public void writeBytesNoTag(ByteString byteString) {
        this.writeUInt32NoTag(byteString.size());
        byteString.writeTo(this);
    }

    @Override
    public void writeByteArrayNoTag(byte[] byArray, int n, int n2) {
        this.writeUInt32NoTag(n2);
        this.write(byArray, n, n2);
    }

    @Override
    public void writeRawBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        } else {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byteBuffer2.clear();
            this.write(byteBuffer2);
        }
    }

    @Override
    public void writeInt32NoTag(int n) {
        if (n >= 0) {
            this.writeUInt32NoTag(n);
        } else {
            this.writeUInt64NoTag(n);
        }
    }

    @Override
    public void writeUInt32NoTag(int n) {
        if (this.position <= this.oneVarintLimit) {
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
        }
        while (this.position < this.limit) {
            if ((n & 0xFFFFFF80) == 0) {
                UnsafeUtil.putByte(this.position++, (byte)n);
                return;
            }
            UnsafeUtil.putByte(this.position++, (byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
        throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
    }

    @Override
    public void writeFixed32NoTag(int n) {
        this.buffer.putInt(this.bufferPos(this.position), n);
        this.position += 4L;
    }

    @Override
    public void writeUInt64NoTag(long l) {
        if (this.position <= this.oneVarintLimit) {
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.position++, (byte)l);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
        }
        while (this.position < this.limit) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                UnsafeUtil.putByte(this.position++, (byte)l);
                return;
            }
            UnsafeUtil.putByte(this.position++, (byte)((int)l & 0x7F | 0x80));
            l >>>= 7;
        }
        throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
    }

    @Override
    public void writeFixed64NoTag(long l) {
        this.buffer.putLong(this.bufferPos(this.position), l);
        this.position += 8L;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.limit - (long)n2 < this.position) {
            if (byArray == null) {
                throw new NullPointerException("value");
            }
            throw new CodedOutputStream$OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2));
        }
        UnsafeUtil.copyMemory(byArray, n, this.position, (long)n2);
        this.position += (long)n2;
    }

    @Override
    public void writeLazy(byte[] byArray, int n, int n2) {
        this.write(byArray, n, n2);
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        try {
            int n = byteBuffer.remaining();
            this.repositionBuffer(this.position);
            this.buffer.put(byteBuffer);
            this.position += (long)n;
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeLazy(ByteBuffer byteBuffer) {
        this.write(byteBuffer);
    }

    @Override
    public void writeStringNoTag(String string) {
        long l = this.position;
        try {
            int n = string.length() * 3;
            int n2 = CodedOutputStream$UnsafeDirectNioEncoder.computeUInt32SizeNoTag(n);
            int n3 = CodedOutputStream$UnsafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
            if (n3 == n2) {
                int n4 = this.bufferPos(this.position) + n3;
                this.buffer.position(n4);
                Utf8.encodeUtf8(string, this.buffer);
                int n5 = this.buffer.position() - n4;
                this.writeUInt32NoTag(n5);
                this.position += (long)n5;
            } else {
                int n6 = Utf8.encodedLength(string);
                this.writeUInt32NoTag(n6);
                this.repositionBuffer(this.position);
                Utf8.encodeUtf8(string, this.buffer);
                this.position += (long)n6;
            }
        }
        catch (Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
            this.position = l;
            this.repositionBuffer(this.position);
            this.inefficientWriteStringNoTag(string, utf8$UnpairedSurrogateException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodedOutputStream$OutOfSpaceException(illegalArgumentException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
    }

    @Override
    public void flush() {
        this.originalBuffer.position(this.bufferPos(this.position));
    }

    @Override
    public int spaceLeft() {
        return (int)(this.limit - this.position);
    }

    @Override
    public int getTotalBytesWritten() {
        return (int)(this.position - this.initialPosition);
    }

    private void repositionBuffer(long l) {
        this.buffer.position(this.bufferPos(l));
    }

    private int bufferPos(long l) {
        return (int)(l - this.address);
    }
}

