/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Descriptors$Descriptor;
import com.google.protobuf.Descriptors$DescriptorPool$DescriptorIntPair;
import com.google.protobuf.Descriptors$DescriptorPool$PackageDescriptor;
import com.google.protobuf.Descriptors$DescriptorPool$SearchFilter;
import com.google.protobuf.Descriptors$DescriptorValidationException;
import com.google.protobuf.Descriptors$EnumDescriptor;
import com.google.protobuf.Descriptors$EnumValueDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor;
import com.google.protobuf.Descriptors$FileDescriptor;
import com.google.protobuf.Descriptors$GenericDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class Descriptors$DescriptorPool {
    private final Set<Descriptors$FileDescriptor> dependencies;
    private boolean allowUnknownDependencies;
    private final Map<String, Descriptors$GenericDescriptor> descriptorsByName = new HashMap<String, Descriptors$GenericDescriptor>();
    private final Map<Descriptors$DescriptorPool$DescriptorIntPair, Descriptors$FieldDescriptor> fieldsByNumber = new HashMap<Descriptors$DescriptorPool$DescriptorIntPair, Descriptors$FieldDescriptor>();
    private final Map<Descriptors$DescriptorPool$DescriptorIntPair, Descriptors$EnumValueDescriptor> enumValuesByNumber = new HashMap<Descriptors$DescriptorPool$DescriptorIntPair, Descriptors$EnumValueDescriptor>();

    Descriptors$DescriptorPool(Descriptors$FileDescriptor[] descriptors$FileDescriptorArray, boolean bl) {
        this.dependencies = new HashSet<Descriptors$FileDescriptor>();
        this.allowUnknownDependencies = bl;
        for (int i = 0; i < descriptors$FileDescriptorArray.length; ++i) {
            this.dependencies.add(descriptors$FileDescriptorArray[i]);
            this.importPublicDependencies(descriptors$FileDescriptorArray[i]);
        }
        for (Descriptors$FileDescriptor descriptors$FileDescriptor : this.dependencies) {
            try {
                this.addPackage(descriptors$FileDescriptor.getPackage(), descriptors$FileDescriptor);
            }
            catch (Descriptors$DescriptorValidationException descriptors$DescriptorValidationException) {
                throw new AssertionError((Object)descriptors$DescriptorValidationException);
            }
        }
    }

    private void importPublicDependencies(Descriptors$FileDescriptor descriptors$FileDescriptor) {
        for (Descriptors$FileDescriptor descriptors$FileDescriptor2 : descriptors$FileDescriptor.getPublicDependencies()) {
            if (!this.dependencies.add(descriptors$FileDescriptor2)) continue;
            this.importPublicDependencies(descriptors$FileDescriptor2);
        }
    }

    Descriptors$GenericDescriptor findSymbol(String string) {
        return this.findSymbol(string, Descriptors$DescriptorPool$SearchFilter.ALL_SYMBOLS);
    }

    Descriptors$GenericDescriptor findSymbol(String string, Descriptors$DescriptorPool$SearchFilter descriptors$DescriptorPool$SearchFilter) {
        Descriptors$GenericDescriptor descriptors$GenericDescriptor = this.descriptorsByName.get(string);
        if (descriptors$GenericDescriptor != null && (descriptors$DescriptorPool$SearchFilter == Descriptors$DescriptorPool$SearchFilter.ALL_SYMBOLS || descriptors$DescriptorPool$SearchFilter == Descriptors$DescriptorPool$SearchFilter.TYPES_ONLY && this.isType(descriptors$GenericDescriptor) || descriptors$DescriptorPool$SearchFilter == Descriptors$DescriptorPool$SearchFilter.AGGREGATES_ONLY && this.isAggregate(descriptors$GenericDescriptor))) {
            return descriptors$GenericDescriptor;
        }
        for (Descriptors$FileDescriptor descriptors$FileDescriptor : this.dependencies) {
            descriptors$GenericDescriptor = Descriptors$FileDescriptor.access$1400((Descriptors$FileDescriptor)descriptors$FileDescriptor).descriptorsByName.get(string);
            if (descriptors$GenericDescriptor == null || descriptors$DescriptorPool$SearchFilter != Descriptors$DescriptorPool$SearchFilter.ALL_SYMBOLS && (descriptors$DescriptorPool$SearchFilter != Descriptors$DescriptorPool$SearchFilter.TYPES_ONLY || !this.isType(descriptors$GenericDescriptor)) && (descriptors$DescriptorPool$SearchFilter != Descriptors$DescriptorPool$SearchFilter.AGGREGATES_ONLY || !this.isAggregate(descriptors$GenericDescriptor))) continue;
            return descriptors$GenericDescriptor;
        }
        return null;
    }

    boolean isType(Descriptors$GenericDescriptor descriptors$GenericDescriptor) {
        return descriptors$GenericDescriptor instanceof Descriptors$Descriptor || descriptors$GenericDescriptor instanceof Descriptors$EnumDescriptor;
    }

    boolean isAggregate(Descriptors$GenericDescriptor descriptors$GenericDescriptor) {
        return descriptors$GenericDescriptor instanceof Descriptors$Descriptor || descriptors$GenericDescriptor instanceof Descriptors$EnumDescriptor || descriptors$GenericDescriptor instanceof Descriptors$DescriptorPool$PackageDescriptor || descriptors$GenericDescriptor instanceof Descriptors.ServiceDescriptor;
    }

    Descriptors$GenericDescriptor lookupSymbol(String string, Descriptors$GenericDescriptor descriptors$GenericDescriptor, Descriptors$DescriptorPool$SearchFilter descriptors$DescriptorPool$SearchFilter) {
        Descriptors$GenericDescriptor descriptors$GenericDescriptor2;
        String string2;
        if (string.startsWith(".")) {
            string2 = string.substring(1);
            descriptors$GenericDescriptor2 = this.findSymbol(string2, descriptors$DescriptorPool$SearchFilter);
        } else {
            int n = string.indexOf(46);
            String string3 = n == -1 ? string : string.substring(0, n);
            StringBuilder stringBuilder = new StringBuilder(descriptors$GenericDescriptor.getFullName());
            while (true) {
                int n2;
                if ((n2 = stringBuilder.lastIndexOf(".")) == -1) {
                    string2 = string;
                    descriptors$GenericDescriptor2 = this.findSymbol(string, descriptors$DescriptorPool$SearchFilter);
                    break;
                }
                stringBuilder.setLength(n2 + 1);
                stringBuilder.append(string3);
                descriptors$GenericDescriptor2 = this.findSymbol(stringBuilder.toString(), Descriptors$DescriptorPool$SearchFilter.AGGREGATES_ONLY);
                if (descriptors$GenericDescriptor2 != null) {
                    if (n != -1) {
                        stringBuilder.setLength(n2 + 1);
                        stringBuilder.append(string);
                        descriptors$GenericDescriptor2 = this.findSymbol(stringBuilder.toString(), descriptors$DescriptorPool$SearchFilter);
                    }
                    string2 = stringBuilder.toString();
                    break;
                }
                stringBuilder.setLength(n2);
            }
        }
        if (descriptors$GenericDescriptor2 == null) {
            if (this.allowUnknownDependencies && descriptors$DescriptorPool$SearchFilter == Descriptors$DescriptorPool$SearchFilter.TYPES_ONLY) {
                String string4 = String.valueOf(String.valueOf(string));
                Descriptors.access$100().warning(new StringBuilder(87 + string4.length()).append("The descriptor for message type \"").append(string4).append("\" can not be found and a placeholder is created for it").toString());
                descriptors$GenericDescriptor2 = new Descriptors$Descriptor(string2);
                this.dependencies.add(descriptors$GenericDescriptor2.getFile());
                return descriptors$GenericDescriptor2;
            }
            String string5 = String.valueOf(String.valueOf(string));
            throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, new StringBuilder(18 + string5.length()).append("\"").append(string5).append("\" is not defined.").toString(), null);
        }
        return descriptors$GenericDescriptor2;
    }

    void addSymbol(Descriptors$GenericDescriptor descriptors$GenericDescriptor) {
        Descriptors$DescriptorPool.validateSymbolName(descriptors$GenericDescriptor);
        String string = descriptors$GenericDescriptor.getFullName();
        Descriptors$GenericDescriptor descriptors$GenericDescriptor2 = this.descriptorsByName.put(string, descriptors$GenericDescriptor);
        if (descriptors$GenericDescriptor2 != null) {
            this.descriptorsByName.put(string, descriptors$GenericDescriptor2);
            if (descriptors$GenericDescriptor.getFile() == descriptors$GenericDescriptor2.getFile()) {
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    String string2 = String.valueOf(String.valueOf(string));
                    throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, new StringBuilder(22 + string2.length()).append("\"").append(string2).append("\" is already defined.").toString(), null);
                }
                String string3 = String.valueOf(String.valueOf(string.substring(n + 1)));
                String string4 = String.valueOf(String.valueOf(string.substring(0, n)));
                throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, new StringBuilder(28 + string3.length() + string4.length()).append("\"").append(string3).append("\" is already defined in \"").append(string4).append("\".").toString(), null);
            }
            String string5 = String.valueOf(String.valueOf(string));
            String string6 = String.valueOf(String.valueOf(descriptors$GenericDescriptor2.getFile().getName()));
            throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, new StringBuilder(33 + string5.length() + string6.length()).append("\"").append(string5).append("\" is already defined in file \"").append(string6).append("\".").toString(), null);
        }
    }

    void addPackage(String string, Descriptors$FileDescriptor descriptors$FileDescriptor) {
        String string2;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string2 = string;
        } else {
            this.addPackage(string.substring(0, n), descriptors$FileDescriptor);
            string2 = string.substring(n + 1);
        }
        Descriptors$GenericDescriptor descriptors$GenericDescriptor = this.descriptorsByName.put(string, new Descriptors$DescriptorPool$PackageDescriptor(string2, string, descriptors$FileDescriptor));
        if (descriptors$GenericDescriptor != null) {
            this.descriptorsByName.put(string, descriptors$GenericDescriptor);
            if (!(descriptors$GenericDescriptor instanceof Descriptors$DescriptorPool$PackageDescriptor)) {
                String string3 = String.valueOf(String.valueOf(string2));
                String string4 = String.valueOf(String.valueOf(descriptors$GenericDescriptor.getFile().getName()));
                throw new Descriptors$DescriptorValidationException(descriptors$FileDescriptor, new StringBuilder(69 + string3.length() + string4.length()).append("\"").append(string3).append("\" is already defined (as something other than a ").append("package) in file \"").append(string4).append("\".").toString(), null);
            }
        }
    }

    void addFieldByNumber(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        Descriptors$DescriptorPool$DescriptorIntPair descriptors$DescriptorPool$DescriptorIntPair = new Descriptors$DescriptorPool$DescriptorIntPair(descriptors$FieldDescriptor.getContainingType(), descriptors$FieldDescriptor.getNumber());
        Descriptors$FieldDescriptor descriptors$FieldDescriptor2 = this.fieldsByNumber.put(descriptors$DescriptorPool$DescriptorIntPair, descriptors$FieldDescriptor);
        if (descriptors$FieldDescriptor2 != null) {
            this.fieldsByNumber.put(descriptors$DescriptorPool$DescriptorIntPair, descriptors$FieldDescriptor2);
            int n = descriptors$FieldDescriptor.getNumber();
            String string = String.valueOf(String.valueOf(descriptors$FieldDescriptor.getContainingType().getFullName()));
            String string2 = String.valueOf(String.valueOf(descriptors$FieldDescriptor2.getName()));
            throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)descriptors$FieldDescriptor, new StringBuilder(65 + string.length() + string2.length()).append("Field number ").append(n).append(" has already been used in \"").append(string).append("\" by field \"").append(string2).append("\".").toString(), null);
        }
    }

    void addEnumValueByNumber(Descriptors$EnumValueDescriptor descriptors$EnumValueDescriptor) {
        Descriptors$DescriptorPool$DescriptorIntPair descriptors$DescriptorPool$DescriptorIntPair = new Descriptors$DescriptorPool$DescriptorIntPair(descriptors$EnumValueDescriptor.getType(), descriptors$EnumValueDescriptor.getNumber());
        Descriptors$EnumValueDescriptor descriptors$EnumValueDescriptor2 = this.enumValuesByNumber.put(descriptors$DescriptorPool$DescriptorIntPair, descriptors$EnumValueDescriptor);
        if (descriptors$EnumValueDescriptor2 != null) {
            this.enumValuesByNumber.put(descriptors$DescriptorPool$DescriptorIntPair, descriptors$EnumValueDescriptor2);
        }
    }

    static void validateSymbolName(Descriptors$GenericDescriptor descriptors$GenericDescriptor) {
        String string = descriptors$GenericDescriptor.getName();
        if (string.length() == 0) {
            throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, "Missing name.", null);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '_' || '0' <= c2 && c2 <= '9' && i > 0) continue;
            String string2 = String.valueOf(String.valueOf(string));
            throw new Descriptors$DescriptorValidationException(descriptors$GenericDescriptor, new StringBuilder(29 + string2.length()).append("\"").append(string2).append("\" is not a valid identifier.").toString(), null);
        }
    }

    static /* synthetic */ Map access$1500(Descriptors$DescriptorPool descriptors$DescriptorPool) {
        return descriptors$DescriptorPool.fieldsByNumber;
    }

    static /* synthetic */ Map access$2400(Descriptors$DescriptorPool descriptors$DescriptorPool) {
        return descriptors$DescriptorPool.enumValuesByNumber;
    }
}

