/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.DescriptorProtos$FieldDescriptorProto;
import com.google.protobuf.DescriptorProtos$FieldDescriptorProto$Label;
import com.google.protobuf.DescriptorProtos$FieldDescriptorProto$Type;
import com.google.protobuf.DescriptorProtos$FieldOptions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Descriptors$1;
import com.google.protobuf.Descriptors$Descriptor;
import com.google.protobuf.Descriptors$DescriptorPool$SearchFilter;
import com.google.protobuf.Descriptors$DescriptorValidationException;
import com.google.protobuf.Descriptors$EnumDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor$JavaType;
import com.google.protobuf.Descriptors$FieldDescriptor$Type;
import com.google.protobuf.Descriptors$FileDescriptor;
import com.google.protobuf.Descriptors$FileDescriptor$Syntax;
import com.google.protobuf.Descriptors$GenericDescriptor;
import com.google.protobuf.Descriptors$OneofDescriptor;
import com.google.protobuf.FieldSet$FieldDescriptorLite;
import com.google.protobuf.Message;
import com.google.protobuf.Message$Builder;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.TextFormat$InvalidEscapeSequenceException;
import com.google.protobuf.WireFormat;
import com.google.protobuf.WireFormat$FieldType;
import java.util.Collections;

public final class Descriptors$FieldDescriptor
extends Descriptors$GenericDescriptor
implements FieldSet$FieldDescriptorLite<Descriptors$FieldDescriptor>,
Comparable<Descriptors$FieldDescriptor> {
    private static final WireFormat$FieldType[] table = WireFormat$FieldType.values();
    private final int index;
    private DescriptorProtos$FieldDescriptorProto proto;
    private final String fullName;
    private final String jsonName;
    private final Descriptors$FileDescriptor file;
    private final Descriptors$Descriptor extensionScope;
    private Descriptors$FieldDescriptor$Type type;
    private Descriptors$Descriptor containingType;
    private Descriptors$Descriptor messageType;
    private Descriptors$OneofDescriptor containingOneof;
    private Descriptors$EnumDescriptor enumType;
    private Object defaultValue;

    public int getIndex() {
        return this.index;
    }

    @Override
    public DescriptorProtos$FieldDescriptorProto toProto() {
        return this.proto;
    }

    @Override
    public String getName() {
        return this.proto.getName();
    }

    @Override
    public int getNumber() {
        return this.proto.getNumber();
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public Descriptors$FieldDescriptor$JavaType getJavaType() {
        return this.type.getJavaType();
    }

    @Override
    public WireFormat.JavaType getLiteJavaType() {
        return this.getLiteType().getJavaType();
    }

    @Override
    public Descriptors$FileDescriptor getFile() {
        return this.file;
    }

    public Descriptors$FieldDescriptor$Type getType() {
        return this.type;
    }

    @Override
    public WireFormat$FieldType getLiteType() {
        return table[this.type.ordinal()];
    }

    public boolean needsUtf8Check() {
        if (this.type != Descriptors$FieldDescriptor$Type.STRING) {
            return false;
        }
        if (this.getContainingType().getOptions().getMapEntry()) {
            return true;
        }
        if (this.getFile().getSyntax() == Descriptors$FileDescriptor$Syntax.PROTO3) {
            return true;
        }
        return this.getFile().getOptions().getJavaStringCheckUtf8();
    }

    public boolean isMapField() {
        return this.getType() == Descriptors$FieldDescriptor$Type.MESSAGE && this.isRepeated() && this.getMessageType().getOptions().getMapEntry();
    }

    public boolean isRequired() {
        return this.proto.getLabel() == DescriptorProtos$FieldDescriptorProto$Label.LABEL_REQUIRED;
    }

    public boolean isOptional() {
        return this.proto.getLabel() == DescriptorProtos$FieldDescriptorProto$Label.LABEL_OPTIONAL;
    }

    @Override
    public boolean isRepeated() {
        return this.proto.getLabel() == DescriptorProtos$FieldDescriptorProto$Label.LABEL_REPEATED;
    }

    @Override
    public boolean isPacked() {
        if (!this.isPackable()) {
            return false;
        }
        if (this.getFile().getSyntax() == Descriptors$FileDescriptor$Syntax.PROTO2) {
            return this.getOptions().getPacked();
        }
        return !this.getOptions().hasPacked() || this.getOptions().getPacked();
    }

    public boolean isPackable() {
        return this.isRepeated() && this.getLiteType().isPackable();
    }

    public boolean hasDefaultValue() {
        return this.proto.hasDefaultValue();
    }

    public Object getDefaultValue() {
        if (this.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
        }
        return this.defaultValue;
    }

    public DescriptorProtos$FieldOptions getOptions() {
        return this.proto.getOptions();
    }

    public boolean isExtension() {
        return this.proto.hasExtendee();
    }

    public Descriptors$Descriptor getContainingType() {
        return this.containingType;
    }

    public Descriptors$OneofDescriptor getContainingOneof() {
        return this.containingOneof;
    }

    public Descriptors$Descriptor getExtensionScope() {
        if (!this.isExtension()) {
            throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
        }
        return this.extensionScope;
    }

    public Descriptors$Descriptor getMessageType() {
        if (this.getJavaType() != Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
        }
        return this.messageType;
    }

    public Descriptors$EnumDescriptor getEnumType() {
        if (this.getJavaType() != Descriptors$FieldDescriptor$JavaType.ENUM) {
            throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
        }
        return this.enumType;
    }

    @Override
    public int compareTo(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        if (descriptors$FieldDescriptor.containingType != this.containingType) {
            throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
        }
        return this.getNumber() - descriptors$FieldDescriptor.getNumber();
    }

    public String toString() {
        return this.getFullName();
    }

    private static String fieldNameToJsonName(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '_') {
                bl = true;
                continue;
            }
            if (bl) {
                if ('a' <= c2 && c2 <= 'z') {
                    c2 = (char)(c2 - 97 + 65);
                }
                stringBuilder.append(c2);
                bl = false;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private Descriptors$FieldDescriptor(DescriptorProtos$FieldDescriptorProto descriptorProtos$FieldDescriptorProto, Descriptors$FileDescriptor descriptors$FileDescriptor, Descriptors$Descriptor descriptors$Descriptor, int n, boolean bl) {
        this.index = n;
        this.proto = descriptorProtos$FieldDescriptorProto;
        this.fullName = Descriptors.access$1600(descriptors$FileDescriptor, descriptors$Descriptor, descriptorProtos$FieldDescriptorProto.getName());
        this.file = descriptors$FileDescriptor;
        this.jsonName = descriptorProtos$FieldDescriptorProto.hasJsonName() ? descriptorProtos$FieldDescriptorProto.getJsonName() : Descriptors$FieldDescriptor.fieldNameToJsonName(descriptorProtos$FieldDescriptorProto.getName());
        if (descriptorProtos$FieldDescriptorProto.hasType()) {
            this.type = Descriptors$FieldDescriptor$Type.valueOf(descriptorProtos$FieldDescriptorProto.getType());
        }
        if (this.getNumber() <= 0) {
            throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Field numbers must be positive integers.", null);
        }
        if (bl) {
            if (!descriptorProtos$FieldDescriptorProto.hasExtendee()) {
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.", null);
            }
            this.containingType = null;
            this.extensionScope = descriptors$Descriptor != null ? descriptors$Descriptor : null;
            if (descriptorProtos$FieldDescriptorProto.hasOneofIndex()) {
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.", null);
            }
            this.containingOneof = null;
        } else {
            if (descriptorProtos$FieldDescriptorProto.hasExtendee()) {
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.", null);
            }
            this.containingType = descriptors$Descriptor;
            if (descriptorProtos$FieldDescriptorProto.hasOneofIndex()) {
                if (descriptorProtos$FieldDescriptorProto.getOneofIndex() < 0 || descriptorProtos$FieldDescriptorProto.getOneofIndex() >= descriptors$Descriptor.toProto().getOneofDeclCount()) {
                    String string = String.valueOf(descriptors$Descriptor.getName());
                    throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, string.length() != 0 ? "FieldDescriptorProto.oneof_index is out of range for type ".concat(string) : new String("FieldDescriptorProto.oneof_index is out of range for type "), null);
                }
                this.containingOneof = descriptors$Descriptor.getOneofs().get(descriptorProtos$FieldDescriptorProto.getOneofIndex());
                Descriptors$OneofDescriptor.access$1908(this.containingOneof);
            } else {
                this.containingOneof = null;
            }
            this.extensionScope = null;
        }
        Descriptors$FileDescriptor.access$1400(descriptors$FileDescriptor).addSymbol(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void crossLink() {
        Object object;
        if (this.proto.hasExtendee()) {
            object = Descriptors$FileDescriptor.access$1400(this.file).lookupSymbol(this.proto.getExtendee(), this, Descriptors$DescriptorPool$SearchFilter.TYPES_ONLY);
            if (!(object instanceof Descriptors$Descriptor)) {
                String string = String.valueOf(String.valueOf(this.proto.getExtendee()));
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(25 + string.length()).append("\"").append(string).append("\" is not a message type.").toString(), null);
            }
            this.containingType = (Descriptors$Descriptor)object;
            if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                String string = String.valueOf(String.valueOf(this.getContainingType().getFullName()));
                int n = this.getNumber();
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(55 + string.length()).append("\"").append(string).append("\" does not declare ").append(n).append(" as an extension number.").toString(), null);
            }
        }
        if (this.proto.hasTypeName()) {
            object = Descriptors$FileDescriptor.access$1400(this.file).lookupSymbol(this.proto.getTypeName(), this, Descriptors$DescriptorPool$SearchFilter.TYPES_ONLY);
            if (!this.proto.hasType()) {
                if (object instanceof Descriptors$Descriptor) {
                    this.type = Descriptors$FieldDescriptor$Type.MESSAGE;
                } else if (object instanceof Descriptors$EnumDescriptor) {
                    this.type = Descriptors$FieldDescriptor$Type.ENUM;
                } else {
                    String string = String.valueOf(String.valueOf(this.proto.getTypeName()));
                    throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(17 + string.length()).append("\"").append(string).append("\" is not a type.").toString(), null);
                }
            }
            if (this.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
                if (!(object instanceof Descriptors$Descriptor)) {
                    String string = String.valueOf(String.valueOf(this.proto.getTypeName()));
                    throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(25 + string.length()).append("\"").append(string).append("\" is not a message type.").toString(), null);
                }
                this.messageType = (Descriptors$Descriptor)object;
                if (this.proto.hasDefaultValue()) {
                    throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Messages can't have default values.", null);
                }
            } else {
                if (this.getJavaType() != Descriptors$FieldDescriptor$JavaType.ENUM) throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Field with primitive type has type_name.", null);
                if (!(object instanceof Descriptors$EnumDescriptor)) {
                    String string = String.valueOf(String.valueOf(this.proto.getTypeName()));
                    throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(23 + string.length()).append("\"").append(string).append("\" is not an enum type.").toString(), null);
                }
                this.enumType = (Descriptors$EnumDescriptor)object;
            }
        } else if (this.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE || this.getJavaType() == Descriptors$FieldDescriptor$JavaType.ENUM) {
            throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Field with message or enum type missing type_name.", null);
        }
        if (this.proto.getOptions().getPacked() && !this.isPackable()) {
            throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.", null);
        }
        if (this.proto.hasDefaultValue()) {
            if (this.isRepeated()) {
                throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Repeated fields cannot have default values.", null);
            }
            try {
                switch (this.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                        break;
                    }
                    case FLOAT: {
                        if (this.proto.getDefaultValue().equals("inf")) {
                            this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                            break;
                        }
                        if (this.proto.getDefaultValue().equals("-inf")) {
                            this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                            break;
                        }
                        if (this.proto.getDefaultValue().equals("nan")) {
                            this.defaultValue = Float.valueOf(Float.NaN);
                            break;
                        }
                        this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                        break;
                    }
                    case DOUBLE: {
                        if (this.proto.getDefaultValue().equals("inf")) {
                            this.defaultValue = Double.POSITIVE_INFINITY;
                            break;
                        }
                        if (this.proto.getDefaultValue().equals("-inf")) {
                            this.defaultValue = Double.NEGATIVE_INFINITY;
                            break;
                        }
                        if (this.proto.getDefaultValue().equals("nan")) {
                            this.defaultValue = Double.NaN;
                            break;
                        }
                        this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                        break;
                    }
                    case BOOL: {
                        this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                        break;
                    }
                    case STRING: {
                        this.defaultValue = this.proto.getDefaultValue();
                        break;
                    }
                    case BYTES: {
                        try {
                            this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                            break;
                        }
                        catch (TextFormat$InvalidEscapeSequenceException textFormat$InvalidEscapeSequenceException) {
                            String string = String.valueOf(textFormat$InvalidEscapeSequenceException.getMessage());
                            throw new Descriptors$DescriptorValidationException(this, string.length() != 0 ? "Couldn't parse default value: ".concat(string) : new String("Couldn't parse default value: "), textFormat$InvalidEscapeSequenceException, null);
                        }
                    }
                    case ENUM: {
                        this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                        if (this.defaultValue != null) break;
                        object = String.valueOf(String.valueOf(this.proto.getDefaultValue()));
                        throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, new StringBuilder(30 + ((String)object).length()).append("Unknown enum default value: \"").append((String)object).append("\"").toString(), null);
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Message type had default value.", null);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(String.valueOf(this.proto.getDefaultValue()));
                throw new Descriptors$DescriptorValidationException(this, new StringBuilder(33 + string.length()).append("Could not parse default value: \"").append(string).append("\"").toString(), numberFormatException, null);
            }
        } else if (this.isRepeated()) {
            this.defaultValue = Collections.emptyList();
        } else {
            switch (this.getJavaType()) {
                case ENUM: {
                    this.defaultValue = this.enumType.getValues().get(0);
                    break;
                }
                case MESSAGE: {
                    this.defaultValue = null;
                    break;
                }
                default: {
                    this.defaultValue = Descriptors$FieldDescriptor$JavaType.access$2300(this.getJavaType());
                }
            }
        }
        if (!this.isExtension()) {
            Descriptors$FileDescriptor.access$1400(this.file).addFieldByNumber(this);
        }
        if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
        if (!this.isExtension()) throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "MessageSets cannot have fields, only extensions.", null);
        if (this.isOptional() && this.getType() == Descriptors$FieldDescriptor$Type.MESSAGE) return;
        throw new Descriptors$DescriptorValidationException((Descriptors$GenericDescriptor)this, "Extensions of MessageSets must be optional messages.", null);
    }

    private void setProto(DescriptorProtos$FieldDescriptorProto descriptorProtos$FieldDescriptorProto) {
        this.proto = descriptorProtos$FieldDescriptorProto;
    }

    @Override
    public MessageLite$Builder internalMergeFrom(MessageLite$Builder messageLite$Builder, MessageLite messageLite) {
        return ((Message$Builder)messageLite$Builder).mergeFrom((Message)messageLite);
    }

    /* synthetic */ Descriptors$FieldDescriptor(DescriptorProtos$FieldDescriptorProto descriptorProtos$FieldDescriptorProto, Descriptors$FileDescriptor descriptors$FileDescriptor, Descriptors$Descriptor descriptors$Descriptor, int n, boolean bl, Descriptors$1 descriptors$1) {
        this(descriptorProtos$FieldDescriptorProto, descriptors$FileDescriptor, descriptors$Descriptor, n, bl);
    }

    static /* synthetic */ void access$900(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        descriptors$FieldDescriptor.crossLink();
    }

    static /* synthetic */ void access$1300(Descriptors$FieldDescriptor descriptors$FieldDescriptor, DescriptorProtos$FieldDescriptorProto descriptorProtos$FieldDescriptorProto) {
        descriptors$FieldDescriptor.setProto(descriptorProtos$FieldDescriptorProto);
    }

    static {
        if (Descriptors$FieldDescriptor$Type.values().length != DescriptorProtos$FieldDescriptorProto$Type.values().length) {
            throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
        }
    }
}

