/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Descriptors$Descriptor;
import com.google.protobuf.Descriptors$FieldDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor$JavaType;
import com.google.protobuf.Descriptors$FieldDescriptor$Type;
import com.google.protobuf.Extension;
import com.google.protobuf.Extension$ExtensionType;
import com.google.protobuf.ExtensionRegistry$DescriptorIntPair;
import com.google.protobuf.ExtensionRegistry$ExtensionInfo;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage$GeneratedExtension;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionRegistry
extends ExtensionRegistryLite {
    private final Map<String, ExtensionRegistry$ExtensionInfo> immutableExtensionsByName;
    private final Map<String, ExtensionRegistry$ExtensionInfo> mutableExtensionsByName;
    private final Map<ExtensionRegistry$DescriptorIntPair, ExtensionRegistry$ExtensionInfo> immutableExtensionsByNumber;
    private final Map<ExtensionRegistry$DescriptorIntPair, ExtensionRegistry$ExtensionInfo> mutableExtensionsByNumber;
    static final ExtensionRegistry EMPTY_REGISTRY = new ExtensionRegistry(true);

    public static ExtensionRegistry newInstance() {
        return new ExtensionRegistry();
    }

    public static ExtensionRegistry getEmptyRegistry() {
        return EMPTY_REGISTRY;
    }

    @Override
    public ExtensionRegistry getUnmodifiable() {
        return new ExtensionRegistry(this);
    }

    @Deprecated
    public ExtensionRegistry$ExtensionInfo findExtensionByName(String string) {
        return this.findImmutableExtensionByName(string);
    }

    public ExtensionRegistry$ExtensionInfo findImmutableExtensionByName(String string) {
        return this.immutableExtensionsByName.get(string);
    }

    public ExtensionRegistry$ExtensionInfo findMutableExtensionByName(String string) {
        return this.mutableExtensionsByName.get(string);
    }

    @Deprecated
    public ExtensionRegistry$ExtensionInfo findExtensionByNumber(Descriptors$Descriptor descriptors$Descriptor, int n) {
        return this.findImmutableExtensionByNumber(descriptors$Descriptor, n);
    }

    public ExtensionRegistry$ExtensionInfo findImmutableExtensionByNumber(Descriptors$Descriptor descriptors$Descriptor, int n) {
        return this.immutableExtensionsByNumber.get(new ExtensionRegistry$DescriptorIntPair(descriptors$Descriptor, n));
    }

    public ExtensionRegistry$ExtensionInfo findMutableExtensionByNumber(Descriptors$Descriptor descriptors$Descriptor, int n) {
        return this.mutableExtensionsByNumber.get(new ExtensionRegistry$DescriptorIntPair(descriptors$Descriptor, n));
    }

    public Set<ExtensionRegistry$ExtensionInfo> getAllMutableExtensionsByExtendedType(String string) {
        HashSet<ExtensionRegistry$ExtensionInfo> hashSet = new HashSet<ExtensionRegistry$ExtensionInfo>();
        for (ExtensionRegistry$DescriptorIntPair extensionRegistry$DescriptorIntPair : this.mutableExtensionsByNumber.keySet()) {
            if (!ExtensionRegistry$DescriptorIntPair.access$000(extensionRegistry$DescriptorIntPair).getFullName().equals(string)) continue;
            hashSet.add(this.mutableExtensionsByNumber.get(extensionRegistry$DescriptorIntPair));
        }
        return hashSet;
    }

    public Set<ExtensionRegistry$ExtensionInfo> getAllImmutableExtensionsByExtendedType(String string) {
        HashSet<ExtensionRegistry$ExtensionInfo> hashSet = new HashSet<ExtensionRegistry$ExtensionInfo>();
        for (ExtensionRegistry$DescriptorIntPair extensionRegistry$DescriptorIntPair : this.immutableExtensionsByNumber.keySet()) {
            if (!ExtensionRegistry$DescriptorIntPair.access$000(extensionRegistry$DescriptorIntPair).getFullName().equals(string)) continue;
            hashSet.add(this.immutableExtensionsByNumber.get(extensionRegistry$DescriptorIntPair));
        }
        return hashSet;
    }

    public void add(Extension<?, ?> extension) {
        if (extension.getExtensionType() != Extension$ExtensionType.IMMUTABLE && extension.getExtensionType() != Extension$ExtensionType.MUTABLE) {
            return;
        }
        this.add(ExtensionRegistry.newExtensionInfo(extension), extension.getExtensionType());
    }

    public void add(GeneratedMessage$GeneratedExtension<?, ?> generatedMessage$GeneratedExtension) {
        this.add((Extension<?, ?>)generatedMessage$GeneratedExtension);
    }

    static ExtensionRegistry$ExtensionInfo newExtensionInfo(Extension<?, ?> extension) {
        if (extension.getDescriptor().getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            if (extension.getMessageDefaultInstance() == null) {
                String string = String.valueOf(extension.getDescriptor().getFullName());
                throw new IllegalStateException(string.length() != 0 ? "Registered message-type extension had null default instance: ".concat(string) : new String("Registered message-type extension had null default instance: "));
            }
            return new ExtensionRegistry$ExtensionInfo(extension.getDescriptor(), (Message)extension.getMessageDefaultInstance(), null);
        }
        return new ExtensionRegistry$ExtensionInfo(extension.getDescriptor(), null, null);
    }

    public void add(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        if (descriptors$FieldDescriptor.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            throw new IllegalArgumentException("ExtensionRegistry.add() must be provided a default instance when adding an embedded message extension.");
        }
        ExtensionRegistry$ExtensionInfo extensionRegistry$ExtensionInfo = new ExtensionRegistry$ExtensionInfo(descriptors$FieldDescriptor, null, null);
        this.add(extensionRegistry$ExtensionInfo, Extension$ExtensionType.IMMUTABLE);
        this.add(extensionRegistry$ExtensionInfo, Extension$ExtensionType.MUTABLE);
    }

    public void add(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Message message) {
        if (descriptors$FieldDescriptor.getJavaType() != Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            throw new IllegalArgumentException("ExtensionRegistry.add() provided a default instance for a non-message extension.");
        }
        this.add(new ExtensionRegistry$ExtensionInfo(descriptors$FieldDescriptor, message, null), Extension$ExtensionType.IMMUTABLE);
    }

    private ExtensionRegistry() {
        this.immutableExtensionsByName = new HashMap<String, ExtensionRegistry$ExtensionInfo>();
        this.mutableExtensionsByName = new HashMap<String, ExtensionRegistry$ExtensionInfo>();
        this.immutableExtensionsByNumber = new HashMap<ExtensionRegistry$DescriptorIntPair, ExtensionRegistry$ExtensionInfo>();
        this.mutableExtensionsByNumber = new HashMap<ExtensionRegistry$DescriptorIntPair, ExtensionRegistry$ExtensionInfo>();
    }

    private ExtensionRegistry(ExtensionRegistry extensionRegistry) {
        super(extensionRegistry);
        this.immutableExtensionsByName = Collections.unmodifiableMap(extensionRegistry.immutableExtensionsByName);
        this.mutableExtensionsByName = Collections.unmodifiableMap(extensionRegistry.mutableExtensionsByName);
        this.immutableExtensionsByNumber = Collections.unmodifiableMap(extensionRegistry.immutableExtensionsByNumber);
        this.mutableExtensionsByNumber = Collections.unmodifiableMap(extensionRegistry.mutableExtensionsByNumber);
    }

    ExtensionRegistry(boolean bl) {
        super(EMPTY_REGISTRY_LITE);
        this.immutableExtensionsByName = Collections.emptyMap();
        this.mutableExtensionsByName = Collections.emptyMap();
        this.immutableExtensionsByNumber = Collections.emptyMap();
        this.mutableExtensionsByNumber = Collections.emptyMap();
    }

    private void add(ExtensionRegistry$ExtensionInfo extensionRegistry$ExtensionInfo, Extension$ExtensionType extension$ExtensionType) {
        Map<ExtensionRegistry$DescriptorIntPair, ExtensionRegistry$ExtensionInfo> map;
        Map<String, ExtensionRegistry$ExtensionInfo> map2;
        if (!extensionRegistry$ExtensionInfo.descriptor.isExtension()) {
            throw new IllegalArgumentException("ExtensionRegistry.add() was given a FieldDescriptor for a regular (non-extension) field.");
        }
        switch (extension$ExtensionType) {
            case IMMUTABLE: {
                map2 = this.immutableExtensionsByName;
                map = this.immutableExtensionsByNumber;
                break;
            }
            case MUTABLE: {
                map2 = this.mutableExtensionsByName;
                map = this.mutableExtensionsByNumber;
                break;
            }
            default: {
                return;
            }
        }
        map2.put(extensionRegistry$ExtensionInfo.descriptor.getFullName(), extensionRegistry$ExtensionInfo);
        map.put(new ExtensionRegistry$DescriptorIntPair(extensionRegistry$ExtensionInfo.descriptor.getContainingType(), extensionRegistry$ExtensionInfo.descriptor.getNumber()), extensionRegistry$ExtensionInfo);
        Descriptors$FieldDescriptor descriptors$FieldDescriptor = extensionRegistry$ExtensionInfo.descriptor;
        if (descriptors$FieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && descriptors$FieldDescriptor.getType() == Descriptors$FieldDescriptor$Type.MESSAGE && descriptors$FieldDescriptor.isOptional() && descriptors$FieldDescriptor.getExtensionScope() == descriptors$FieldDescriptor.getMessageType()) {
            map2.put(descriptors$FieldDescriptor.getMessageType().getFullName(), extensionRegistry$ExtensionInfo);
        }
    }
}

