/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.Internal$FloatList;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal$FloatList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList(new float[0], 0);
    private float[] array;
    private int size;

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    FloatArrayList() {
        this(new float[10], 0);
    }

    private FloatArrayList(float[] fArray, int n) {
        this.array = fArray;
        this.size = n;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.ensureIsMutable();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n2, this.array, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatArrayList)) {
            return super.equals(object);
        }
        FloatArrayList floatArrayList = (FloatArrayList)object;
        if (this.size != floatArrayList.size) {
            return false;
        }
        float[] fArray = floatArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.array[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + Float.floatToIntBits(this.array[i]);
        }
        return n;
    }

    @Override
    public Internal$FloatList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new FloatArrayList(Arrays.copyOf(this.array, n), this.size);
    }

    @Override
    public Float get(int n) {
        return Float.valueOf(this.getFloat(n));
    }

    @Override
    public float getFloat(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float set(int n, Float f2) {
        return Float.valueOf(this.setFloat(n, f2.floatValue()));
    }

    @Override
    public float setFloat(int n, float f2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        float f3 = this.array[n];
        this.array[n] = f2;
        return f3;
    }

    @Override
    public void add(int n, Float f2) {
        this.addFloat(n, f2.floatValue());
    }

    @Override
    public void addFloat(float f2) {
        this.addFloat(this.size, f2);
    }

    private void addFloat(int n, float f2) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            float[] fArray = new float[n2];
            System.arraycopy(this.array, 0, fArray, 0, n);
            System.arraycopy(this.array, n, fArray, n + 1, this.size - n);
            this.array = fArray;
        }
        this.array[n] = f2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList floatArrayList = (FloatArrayList)collection;
        if (floatArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < floatArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + floatArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(floatArrayList.array, 0, this.array, this.size, floatArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.array[i]))) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Float remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        float f2 = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return Float.valueOf(f2);
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = n;
        int n3 = this.size;
        return new StringBuilder(35).append("Index:").append(n2).append(", Size:").append(n3).toString();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

