/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal$EnumLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Utf8;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public final class Internal {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
    public static final CodedInputStream EMPTY_CODED_INPUT_STREAM = CodedInputStream.newInstance(EMPTY_BYTE_ARRAY);

    private Internal() {
    }

    static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    static <T> T checkNotNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    public static String stringDefaultValue(String string) {
        return new String(string.getBytes(ISO_8859_1), UTF_8);
    }

    public static ByteString bytesDefaultValue(String string) {
        return ByteString.copyFrom(string.getBytes(ISO_8859_1));
    }

    public static byte[] byteArrayDefaultValue(String string) {
        return string.getBytes(ISO_8859_1);
    }

    public static ByteBuffer byteBufferDefaultValue(String string) {
        return ByteBuffer.wrap(Internal.byteArrayDefaultValue(string));
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.clear();
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer2.capacity());
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.clear();
        return byteBuffer3;
    }

    public static boolean isValidUtf8(ByteString byteString) {
        return byteString.isValidUtf8();
    }

    public static boolean isValidUtf8(byte[] byArray) {
        return Utf8.isValidUtf8(byArray);
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes(UTF_8);
    }

    public static String toStringUtf8(byte[] byArray) {
        return new String(byArray, UTF_8);
    }

    public static int hashLong(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int hashBoolean(boolean bl) {
        return bl ? 1231 : 1237;
    }

    public static int hashEnum(Internal$EnumLite internal$EnumLite) {
        return internal$EnumLite.getNumber();
    }

    public static int hashEnumList(List<? extends Internal$EnumLite> list) {
        int n = 1;
        for (Internal$EnumLite internal$EnumLite : list) {
            n = 31 * n + Internal.hashEnum(internal$EnumLite);
        }
        return n;
    }

    public static boolean equals(List<byte[]> list, List<byte[]> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (Arrays.equals(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(List<byte[]> list) {
        int n = 1;
        for (byte[] byArray : list) {
            n = 31 * n + Internal.hashCode(byArray);
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        return Internal.hashCode(byArray, 0, byArray.length);
    }

    static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = Internal.partialHash(n2, byArray, n, n2);
        return n3 == 0 ? 1 : n3;
    }

    static int partialHash(int n, byte[] byArray, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            n = n * 31 + byArray[i];
        }
        return n;
    }

    public static boolean equalsByteBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.capacity() != byteBuffer2.capacity()) {
            return false;
        }
        return byteBuffer.duplicate().clear().equals(byteBuffer2.duplicate().clear());
    }

    public static boolean equalsByteBuffer(List<ByteBuffer> list, List<ByteBuffer> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (Internal.equalsByteBuffer(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeByteBuffer(List<ByteBuffer> list) {
        int n = 1;
        for (ByteBuffer byteBuffer : list) {
            n = 31 * n + Internal.hashCodeByteBuffer(byteBuffer);
        }
        return n;
    }

    public static int hashCodeByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = Internal.partialHash(byteBuffer.capacity(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            return n == 0 ? 1 : n;
        }
        int n = byteBuffer.capacity() > 4096 ? 4096 : byteBuffer.capacity();
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.clear();
        int n2 = byteBuffer.capacity();
        while (byteBuffer2.remaining() > 0) {
            int n3 = byteBuffer2.remaining() <= n ? byteBuffer2.remaining() : n;
            byteBuffer2.get(byArray, 0, n3);
            n2 = Internal.partialHash(n2, byArray, 0, n3);
        }
        return n2 == 0 ? 1 : n2;
    }

    public static <T extends MessageLite> T getDefaultInstance(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((MessageLite)method.invoke((Object)method, new Object[0]));
        }
        catch (Exception exception) {
            String string = String.valueOf(String.valueOf(clazz));
            throw new RuntimeException(new StringBuilder(35 + string.length()).append("Failed to get default instance for ").append(string).toString(), exception);
        }
    }

    static Object mergeMessage(Object object, Object object2) {
        return ((MessageLite)object).toBuilder().mergeFrom((MessageLite)object2).buildPartial();
    }
}

