/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import com.google.protobuf.UnsafeUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;

class IterableByteBufferInputStream
extends InputStream {
    private Iterator<ByteBuffer> iterator;
    private ByteBuffer currentByteBuffer;
    private int dataSize;
    private int currentIndex;
    private int currentByteBufferPos;
    private boolean hasArray;
    private byte[] currentArray;
    private int currentArrayOffset;
    private long currentAddress;

    IterableByteBufferInputStream(Iterable<ByteBuffer> iterable) {
        this.iterator = iterable.iterator();
        this.dataSize = 0;
        for (ByteBuffer byteBuffer : iterable) {
            ++this.dataSize;
        }
        this.currentIndex = -1;
        if (!this.getNextByteBuffer()) {
            this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
            this.currentIndex = 0;
            this.currentByteBufferPos = 0;
            this.currentAddress = 0L;
        }
    }

    private boolean getNextByteBuffer() {
        ++this.currentIndex;
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.currentByteBuffer = this.iterator.next();
        this.currentByteBufferPos = this.currentByteBuffer.position();
        if (this.currentByteBuffer.hasArray()) {
            this.hasArray = true;
            this.currentArray = this.currentByteBuffer.array();
            this.currentArrayOffset = this.currentByteBuffer.arrayOffset();
        } else {
            this.hasArray = false;
            this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
            this.currentArray = null;
        }
        return true;
    }

    private void updateCurrentByteBufferPos(int n) {
        this.currentByteBufferPos += n;
        if (this.currentByteBufferPos == this.currentByteBuffer.limit()) {
            this.getNextByteBuffer();
        }
    }

    @Override
    public int read() {
        if (this.currentIndex == this.dataSize) {
            return -1;
        }
        if (this.hasArray) {
            int n = this.currentArray[this.currentByteBufferPos + this.currentArrayOffset] & 0xFF;
            this.updateCurrentByteBufferPos(1);
            return n;
        }
        int n = UnsafeUtil.getByte((long)this.currentByteBufferPos + this.currentAddress) & 0xFF;
        this.updateCurrentByteBufferPos(1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.currentIndex == this.dataSize) {
            return -1;
        }
        int n3 = this.currentByteBuffer.limit() - this.currentByteBufferPos;
        if (n2 > n3) {
            n2 = n3;
        }
        if (this.hasArray) {
            System.arraycopy(this.currentArray, this.currentByteBufferPos + this.currentArrayOffset, byArray, n, n2);
            this.updateCurrentByteBufferPos(n2);
        } else {
            int n4 = this.currentByteBuffer.position();
            this.currentByteBuffer.position(this.currentByteBufferPos);
            this.currentByteBuffer.get(byArray, n, n2);
            this.currentByteBuffer.position(n4);
            this.updateCurrentByteBufferPos(n2);
        }
        return n2;
    }
}

