/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors$Descriptor;
import com.google.protobuf.Descriptors$FieldDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor$Type;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry$1;
import com.google.protobuf.MapEntry$Builder;
import com.google.protobuf.MapEntry$Metadata;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat$FieldType;
import com.google.protobuf.WireFormat$JavaType;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class MapEntry<K, V>
extends AbstractMessage {
    private final K key;
    private final V value;
    private final MapEntry$Metadata<K, V> metadata;
    private volatile int cachedSerializedSize = -1;

    private MapEntry(Descriptors$Descriptor descriptors$Descriptor, WireFormat$FieldType wireFormat$FieldType, K k, WireFormat$FieldType wireFormat$FieldType2, V v) {
        this.key = k;
        this.value = v;
        this.metadata = new MapEntry$Metadata(descriptors$Descriptor, this, wireFormat$FieldType, wireFormat$FieldType2);
    }

    private MapEntry(MapEntry$Metadata mapEntry$Metadata, K k, V v) {
        this.key = k;
        this.value = v;
        this.metadata = mapEntry$Metadata;
    }

    private MapEntry(MapEntry$Metadata<K, V> mapEntry$Metadata, CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
        try {
            this.metadata = mapEntry$Metadata;
            Map.Entry<K, V> entry = MapEntryLite.parseEntry(codedInputStream, mapEntry$Metadata, extensionRegistryLite);
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage(this);
        }
        catch (IOException iOException) {
            throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage(this);
        }
    }

    public static <K, V> MapEntry<K, V> newDefaultInstance(Descriptors$Descriptor descriptors$Descriptor, WireFormat$FieldType wireFormat$FieldType, K k, WireFormat$FieldType wireFormat$FieldType2, V v) {
        return new MapEntry<K, V>(descriptors$Descriptor, wireFormat$FieldType, k, wireFormat$FieldType2, v);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int getSerializedSize() {
        int n;
        if (this.cachedSerializedSize != -1) {
            return this.cachedSerializedSize;
        }
        this.cachedSerializedSize = n = MapEntryLite.computeSerializedSize(this.metadata, this.key, this.value);
        return n;
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) {
        MapEntryLite.writeTo(codedOutputStream, this.metadata, this.key, this.value);
    }

    @Override
    public boolean isInitialized() {
        return MapEntry.isInitialized(this.metadata, this.value);
    }

    public Parser<MapEntry<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public MapEntry$Builder<K, V> newBuilderForType() {
        return new MapEntry$Builder(this.metadata, null);
    }

    @Override
    public MapEntry$Builder<K, V> toBuilder() {
        return new MapEntry$Builder(this.metadata, this.key, this.value, true, true, null);
    }

    @Override
    public MapEntry<K, V> getDefaultInstanceForType() {
        return new MapEntry<Object, Object>(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
    }

    @Override
    public Descriptors$Descriptor getDescriptorForType() {
        return this.metadata.descriptor;
    }

    @Override
    public Map<Descriptors$FieldDescriptor, Object> getAllFields() {
        TreeMap<Descriptors$FieldDescriptor, Object> treeMap = new TreeMap<Descriptors$FieldDescriptor, Object>();
        for (Descriptors$FieldDescriptor descriptors$FieldDescriptor : this.metadata.descriptor.getFields()) {
            if (!this.hasField(descriptors$FieldDescriptor)) continue;
            treeMap.put(descriptors$FieldDescriptor, this.getField(descriptors$FieldDescriptor));
        }
        return Collections.unmodifiableMap(treeMap);
    }

    private void checkFieldDescriptor(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        if (descriptors$FieldDescriptor.getContainingType() != this.metadata.descriptor) {
            String string = String.valueOf(String.valueOf(descriptors$FieldDescriptor.getFullName()));
            String string2 = String.valueOf(String.valueOf(this.metadata.descriptor.getFullName()));
            throw new RuntimeException(new StringBuilder(42 + string.length() + string2.length()).append("Wrong FieldDescriptor \"").append(string).append("\" used in message \"").append(string2).toString());
        }
    }

    @Override
    public boolean hasField(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        this.checkFieldDescriptor(descriptors$FieldDescriptor);
        return true;
    }

    @Override
    public Object getField(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        Object object;
        this.checkFieldDescriptor(descriptors$FieldDescriptor);
        Object object2 = object = descriptors$FieldDescriptor.getNumber() == 1 ? this.getKey() : this.getValue();
        if (descriptors$FieldDescriptor.getType() == Descriptors$FieldDescriptor$Type.ENUM) {
            object = descriptors$FieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown((Integer)object);
        }
        return object;
    }

    @Override
    public int getRepeatedFieldCount(Descriptors$FieldDescriptor descriptors$FieldDescriptor) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public Object getRepeatedField(Descriptors$FieldDescriptor descriptors$FieldDescriptor, int n) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        return UnknownFieldSet.getDefaultInstance();
    }

    private static <V> boolean isInitialized(MapEntry$Metadata mapEntry$Metadata, V v) {
        if (mapEntry$Metadata.valueType.getJavaType() == WireFormat$JavaType.MESSAGE) {
            return ((MessageLite)v).isInitialized();
        }
        return true;
    }

    final MapEntry$Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static /* synthetic */ Object access$000(MapEntry mapEntry) {
        return mapEntry.key;
    }

    static /* synthetic */ Object access$100(MapEntry mapEntry) {
        return mapEntry.value;
    }

    /* synthetic */ MapEntry(MapEntry$Metadata mapEntry$Metadata, CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite, MapEntry$1 mapEntry$1) {
        this(mapEntry$Metadata, codedInputStream, extensionRegistryLite);
    }

    /* synthetic */ MapEntry(MapEntry$Metadata mapEntry$Metadata, Object object, Object object2, MapEntry$1 mapEntry$1) {
        this(mapEntry$Metadata, object, object2);
    }

    static /* synthetic */ boolean access$600(MapEntry$Metadata mapEntry$Metadata, Object object) {
        return MapEntry.isInitialized(mapEntry$Metadata, object);
    }
}

