/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteBufferWriter;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$LeafByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.NioByteString$1;
import com.google.protobuf.RopeByteString;
import com.google.protobuf.Utf8;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

final class NioByteString
extends ByteString$LeafByteString {
    private final ByteBuffer buffer;

    NioByteString(ByteBuffer byteBuffer) {
        Internal.checkNotNull(byteBuffer, "buffer");
        this.buffer = byteBuffer.slice().order(ByteOrder.nativeOrder());
    }

    private Object writeReplace() {
        return ByteString.copyFrom(this.buffer.slice());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("NioByteString instances are not to be serialized directly");
    }

    @Override
    public byte byteAt(int n) {
        try {
            return this.buffer.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public byte internalByteAt(int n) {
        return this.byteAt(n);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public ByteString substring(int n, int n2) {
        try {
            ByteBuffer byteBuffer = this.slice(n, n2);
            return new NioByteString(byteBuffer);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(n);
        byteBuffer.get(byArray, n2, n3);
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.buffer.slice());
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.toByteArray());
    }

    @Override
    boolean equalsRange(ByteString byteString, int n, int n2) {
        return this.substring(0, n2).equals(byteString.substring(n, n + n2));
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        if (this.buffer.hasArray()) {
            int n3 = this.buffer.arrayOffset() + this.buffer.position() + n;
            outputStream.write(this.buffer.array(), n3, n2);
            return;
        }
        ByteBufferWriter.write(this.slice(n, n + n2), outputStream);
    }

    @Override
    void writeTo(ByteOutput byteOutput) {
        byteOutput.writeLazy(this.buffer.slice());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    protected String toStringInternal(Charset charset) {
        int n;
        int n2;
        byte[] byArray;
        if (this.buffer.hasArray()) {
            byArray = this.buffer.array();
            n2 = this.buffer.arrayOffset() + this.buffer.position();
            n = this.buffer.remaining();
        } else {
            byArray = this.toByteArray();
            n2 = 0;
            n = byArray.length;
        }
        return new String(byArray, n2, n, charset);
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        return Utf8.partialIsValidUtf8(n, this.buffer, n2, n2 + n3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.size() != byteString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (object instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)object).buffer);
        }
        if (object instanceof RopeByteString) {
            return object.equals(this);
        }
        return this.buffer.equals(byteString.asReadOnlyByteBuffer());
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            n = n * 31 + this.buffer.get(i);
        }
        return n;
    }

    @Override
    public InputStream newInput() {
        return new NioByteString$1(this);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private ByteBuffer slice(int n, int n2) {
        if (n < this.buffer.position() || n2 > this.buffer.limit() || n > n2) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", n, n2));
        }
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(n - this.buffer.position());
        byteBuffer.limit(n2 - this.buffer.position());
        return byteBuffer;
    }

    static /* synthetic */ ByteBuffer access$000(NioByteString nioByteString) {
        return nioByteString.buffer;
    }
}

