/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString$LeafByteString;
import com.google.protobuf.RopeByteString;
import com.google.protobuf.RopeByteString$PieceIterator;
import java.io.InputStream;

class RopeByteString$RopeInputStream
extends InputStream {
    private RopeByteString$PieceIterator pieceIterator;
    private ByteString$LeafByteString currentPiece;
    private int currentPieceSize;
    private int currentPieceIndex;
    private int currentPieceOffsetInRope;
    private int mark;
    final /* synthetic */ RopeByteString this$0;

    public RopeByteString$RopeInputStream(RopeByteString ropeByteString) {
        this.this$0 = ropeByteString;
        this.initialize();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        return this.readSkipInternal(byArray, n, n2);
    }

    @Override
    public long skip(long l) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return this.readSkipInternal(null, 0, (int)l);
    }

    private int readSkipInternal(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        for (n3 = n2; n3 > 0; n3 -= n4) {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                if (n3 != n2) break;
                return -1;
            }
            int n5 = this.currentPieceSize - this.currentPieceIndex;
            n4 = Math.min(n5, n3);
            if (byArray != null) {
                this.currentPiece.copyTo(byArray, this.currentPieceIndex, n, n4);
                n += n4;
            }
            this.currentPieceIndex += n4;
        }
        return n2 - n3;
    }

    @Override
    public int read() {
        this.advanceIfCurrentPieceFullyRead();
        if (this.currentPiece == null) {
            return -1;
        }
        return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
    }

    @Override
    public int available() {
        int n = this.currentPieceOffsetInRope + this.currentPieceIndex;
        return this.this$0.size() - n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
    }

    @Override
    public synchronized void reset() {
        this.initialize();
        this.readSkipInternal(null, 0, this.mark);
    }

    private void initialize() {
        this.pieceIterator = new RopeByteString$PieceIterator(this.this$0, null);
        this.currentPiece = this.pieceIterator.next();
        this.currentPieceSize = this.currentPiece.size();
        this.currentPieceIndex = 0;
        this.currentPieceOffsetInRope = 0;
    }

    private void advanceIfCurrentPieceFullyRead() {
        if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
            this.currentPieceOffsetInRope += this.currentPieceSize;
            this.currentPieceIndex = 0;
            if (this.pieceIterator.hasNext()) {
                this.currentPiece = this.pieceIterator.next();
                this.currentPieceSize = this.currentPiece.size();
            } else {
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }
    }
}

