/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$ByteIterator;
import com.google.protobuf.ByteString$LeafByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.RopeByteString$1;
import com.google.protobuf.RopeByteString$Balancer;
import com.google.protobuf.RopeByteString$PieceIterator;
import com.google.protobuf.RopeByteString$RopeInputStream;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

final class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private static final long serialVersionUID = 1L;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = byteString.size();
        this.totalLength = this.leftLength + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        int n;
        if (byteString2.size() == 0) {
            return byteString;
        }
        if (byteString.size() == 0) {
            return byteString2;
        }
        int n2 = byteString.size() + byteString2.size();
        if (n2 < 128) {
            return RopeByteString.concatenateBytes(byteString, byteString2);
        }
        if (byteString instanceof RopeByteString) {
            RopeByteString ropeByteString = (RopeByteString)byteString;
            if (ropeByteString.right.size() + byteString2.size() < 128) {
                ByteString byteString3 = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, byteString3);
            }
            if (ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                RopeByteString ropeByteString2 = new RopeByteString(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, ropeByteString2);
            }
        }
        if (n2 >= minLengthByDepth[n = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1]) {
            return new RopeByteString(byteString, byteString2);
        }
        return RopeByteString$Balancer.access$100(new RopeByteString$Balancer(null), byteString, byteString2);
    }

    private static ByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        int n = byteString.size();
        int n2 = byteString2.size();
        byte[] byArray = new byte[n + n2];
        byteString.copyTo(byArray, 0, 0, n);
        byteString2.copyTo(byArray, 0, n, n2);
        return ByteString.wrap(byArray);
    }

    static RopeByteString newInstanceForTest(ByteString byteString, ByteString byteString2) {
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    public byte byteAt(int n) {
        RopeByteString.checkIndex(n, this.totalLength);
        return this.internalByteAt(n);
    }

    @Override
    byte internalByteAt(int n) {
        if (n < this.leftLength) {
            return this.left.internalByteAt(n);
        }
        return this.right.internalByteAt(n - this.leftLength);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    public ByteString$ByteIterator iterator() {
        return new RopeByteString$1(this);
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    @Override
    public ByteString substring(int n, int n2) {
        int n3 = RopeByteString.checkRange(n, n2, this.totalLength);
        if (n3 == 0) {
            return ByteString.EMPTY;
        }
        if (n3 == this.totalLength) {
            return this;
        }
        if (n2 <= this.leftLength) {
            return this.left.substring(n, n2);
        }
        if (n >= this.leftLength) {
            return this.right.substring(n - this.leftLength, n2 - this.leftLength);
        }
        ByteString byteString = this.left.substring(n);
        ByteString byteString2 = this.right.substring(0, n2 - this.leftLength);
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        if (n + n3 <= this.leftLength) {
            this.left.copyToInternal(byArray, n, n2, n3);
        } else if (n >= this.leftLength) {
            this.right.copyToInternal(byArray, n - this.leftLength, n2, n3);
        } else {
            int n4 = this.leftLength - n;
            this.left.copyToInternal(byArray, n, n2, n4);
            this.right.copyToInternal(byArray, 0, n2 + n4, n3 - n4);
        }
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        this.left.copyTo(byteBuffer);
        this.right.copyTo(byteBuffer);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        RopeByteString$PieceIterator ropeByteString$PieceIterator = new RopeByteString$PieceIterator(this, null);
        while (ropeByteString$PieceIterator.hasNext()) {
            ByteString$LeafByteString byteString$LeafByteString = ropeByteString$PieceIterator.next();
            arrayList.add(byteString$LeafByteString.asReadOnlyByteBuffer());
        }
        return arrayList;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.left.writeTo(outputStream);
        this.right.writeTo(outputStream);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        if (n + n2 <= this.leftLength) {
            this.left.writeToInternal(outputStream, n, n2);
        } else if (n >= this.leftLength) {
            this.right.writeToInternal(outputStream, n - this.leftLength, n2);
        } else {
            int n3 = this.leftLength - n;
            this.left.writeToInternal(outputStream, n, n3);
            this.right.writeToInternal(outputStream, 0, n2 - n3);
        }
    }

    @Override
    void writeTo(ByteOutput byteOutput) {
        this.left.writeTo(byteOutput);
        this.right.writeTo(byteOutput);
    }

    @Override
    protected String toStringInternal(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public boolean isValidUtf8() {
        int n = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int n2 = this.right.partialIsValidUtf8(n, 0, this.right.size());
        return n2 == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialIsValidUtf8(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialIsValidUtf8(n, n2 - this.leftLength, n3);
        }
        int n5 = this.leftLength - n2;
        int n6 = this.left.partialIsValidUtf8(n, n2, n5);
        return this.right.partialIsValidUtf8(n6, 0, n3 - n5);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.totalLength != byteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int n = this.peekCachedHashCode();
        int n2 = byteString.peekCachedHashCode();
        if (n != 0 && n2 != 0 && n != n2) {
            return false;
        }
        return this.equalsFragments(byteString);
    }

    private boolean equalsFragments(ByteString byteString) {
        int n = 0;
        RopeByteString$PieceIterator ropeByteString$PieceIterator = new RopeByteString$PieceIterator(this, null);
        ByteString$LeafByteString byteString$LeafByteString = (ByteString$LeafByteString)ropeByteString$PieceIterator.next();
        int n2 = 0;
        RopeByteString$PieceIterator ropeByteString$PieceIterator2 = new RopeByteString$PieceIterator(byteString, null);
        ByteString$LeafByteString byteString$LeafByteString2 = (ByteString$LeafByteString)ropeByteString$PieceIterator2.next();
        int n3 = 0;
        while (true) {
            boolean bl;
            int n4 = byteString$LeafByteString.size() - n;
            int n5 = byteString$LeafByteString2.size() - n2;
            int n6 = Math.min(n4, n5);
            boolean bl2 = bl = n == 0 ? byteString$LeafByteString.equalsRange(byteString$LeafByteString2, n2, n6) : byteString$LeafByteString2.equalsRange(byteString$LeafByteString, n, n6);
            if (!bl) {
                return false;
            }
            if ((n3 += n6) >= this.totalLength) {
                if (n3 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                byteString$LeafByteString = (ByteString$LeafByteString)ropeByteString$PieceIterator.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                n2 = 0;
                byteString$LeafByteString2 = (ByteString$LeafByteString)ropeByteString$PieceIterator2.next();
                continue;
            }
            n2 += n6;
        }
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialHash(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialHash(n, n2 - this.leftLength, n3);
        }
        int n5 = this.leftLength - n2;
        int n6 = this.left.partialHash(n, n2, n5);
        return this.right.partialHash(n6, 0, n3 - n5);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(new RopeByteString$RopeInputStream(this));
    }

    @Override
    public InputStream newInput() {
        return new RopeByteString$RopeInputStream(this);
    }

    Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("RopeByteStream instances are not to be serialized directly");
    }

    /* synthetic */ RopeByteString(ByteString byteString, ByteString byteString2, RopeByteString$1 ropeByteString$1) {
        this(byteString, byteString2);
    }

    static /* synthetic */ ByteString access$400(RopeByteString ropeByteString) {
        return ropeByteString.left;
    }

    static /* synthetic */ ByteString access$500(RopeByteString ropeByteString) {
        return ropeByteString.right;
    }

    static /* synthetic */ int[] access$600() {
        return minLengthByDepth;
    }

    static {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 1;
        int n3 = 1;
        while (n3 > 0) {
            arrayList.add(n3);
            n = n2 + n3;
            n2 = n3;
            n3 = n;
        }
        arrayList.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[arrayList.size()];
        for (n = 0; n < minLengthByDepth.length; ++n) {
            RopeByteString.minLengthByDepth[n] = (Integer)arrayList.get(n);
        }
    }
}

