/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.TextFormatEscaper$1;
import com.google.protobuf.TextFormatEscaper$2;
import com.google.protobuf.TextFormatEscaper$ByteSequence;

final class TextFormatEscaper {
    private TextFormatEscaper() {
    }

    static String escapeBytes(TextFormatEscaper$ByteSequence textFormatEscaper$ByteSequence) {
        StringBuilder stringBuilder = new StringBuilder(textFormatEscaper$ByteSequence.size());
        block12: for (int i = 0; i < textFormatEscaper$ByteSequence.size(); ++i) {
            byte by = textFormatEscaper$ByteSequence.byteAt(i);
            switch (by) {
                case 7: {
                    stringBuilder.append("\\a");
                    continue block12;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    continue block12;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block12;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (by >= 32 && by <= 126) {
                        stringBuilder.append((char)by);
                        continue block12;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)(48 + (by >>> 6 & 3)));
                    stringBuilder.append((char)(48 + (by >>> 3 & 7)));
                    stringBuilder.append((char)(48 + (by & 7)));
                }
            }
        }
        return stringBuilder.toString();
    }

    static String escapeBytes(ByteString byteString) {
        return TextFormatEscaper.escapeBytes(new TextFormatEscaper$1(byteString));
    }

    static String escapeBytes(byte[] byArray) {
        return TextFormatEscaper.escapeBytes(new TextFormatEscaper$2(byArray));
    }

    static String escapeText(String string) {
        return TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(string));
    }

    static String escapeDoubleQuotesAndBackslashes(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

