/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$DecodeUtil;
import com.google.protobuf.Utf8$Processor;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import java.nio.ByteBuffer;

final class Utf8$SafeProcessor
extends Utf8$Processor {
    Utf8$SafeProcessor() {
    }

    @Override
    int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
        if (n != 0) {
            if (n2 >= n3) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62 || byArray[n2++] > -65) {
                    return -1;
                }
            } else if (by < -16) {
                byte by2 = (byte)(~(n >> 8));
                if (by2 == 0) {
                    by2 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.access$000(by, by2);
                    }
                }
                if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || byArray[n2++] > -65) {
                    return -1;
                }
            } else {
                byte by3 = (byte)(~(n >> 8));
                byte by4 = 0;
                if (by3 == 0) {
                    by3 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.access$000(by, by3);
                    }
                } else {
                    by4 = (byte)(n >> 16);
                }
                if (by4 == 0) {
                    by4 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.access$100(by, by3, by4);
                    }
                }
                if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || byArray[n2++] > -65) {
                    return -1;
                }
            }
        }
        return Utf8$SafeProcessor.partialIsValidUtf8(byArray, n2, n3);
    }

    @Override
    int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
        return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
    }

    @Override
    String decodeUtf8(byte[] byArray, int n, int n2) {
        byte by;
        int n3;
        if ((n | n2 | byArray.length - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n, n2));
        }
        int n4 = n3 + n2;
        char[] cArray = new char[n2];
        int n5 = 0;
        for (n3 = n; n3 < n4 && Utf8$DecodeUtil.access$400(by = byArray[n3]); ++n3) {
            Utf8$DecodeUtil.access$500(by, cArray, n5++);
        }
        while (n3 < n4) {
            if (Utf8$DecodeUtil.access$400(by = byArray[n3++])) {
                byte by2;
                Utf8$DecodeUtil.access$500(by, cArray, n5++);
                while (n3 < n4 && Utf8$DecodeUtil.access$400(by2 = byArray[n3])) {
                    ++n3;
                    Utf8$DecodeUtil.access$500(by2, cArray, n5++);
                }
                continue;
            }
            if (Utf8$DecodeUtil.access$600(by)) {
                if (n3 >= n4) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$700(by, byArray[n3++], cArray, n5++);
                continue;
            }
            if (Utf8$DecodeUtil.access$800(by)) {
                if (n3 >= n4 - 1) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$900(by, byArray[n3++], byArray[n3++], cArray, n5++);
                continue;
            }
            if (n3 >= n4 - 2) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            Utf8$DecodeUtil.access$1000(by, byArray[n3++], byArray[n3++], byArray[n3++], cArray, n5++);
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    @Override
    String decodeUtf8Direct(ByteBuffer byteBuffer, int n, int n2) {
        return this.decodeUtf8Default(byteBuffer, n, n2);
    }

    @Override
    int encodeUtf8(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c2;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c2 = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c2;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            int n7;
            char c3;
            c2 = charSequence.charAt(n3);
            if (c2 < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c2;
            } else if (c2 < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c2 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c2);
            } else if ((c2 < '\ud800' || '\udfff' < c2) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c2 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c2 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c2);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n3))) {
                    throw new Utf8$UnpairedSurrogateException(n3 - 1, n4);
                }
                n7 = Character.toCodePoint(c2, c3);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c2 || c2 > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c2, charSequence.charAt(n3 + 1)))) {
                    throw new Utf8$UnpairedSurrogateException(n3, n4);
                }
                c3 = c2;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c3).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    @Override
    void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
        this.encodeUtf8Default(charSequence, byteBuffer);
    }

    private static int partialIsValidUtf8(byte[] byArray, int n, int n2) {
        while (n < n2 && byArray[n] >= 0) {
            ++n;
        }
        return n >= n2 ? 0 : Utf8$SafeProcessor.partialIsValidUtf8NonAscii(byArray, n, n2);
    }

    private static int partialIsValidUtf8NonAscii(byte[] byArray, int n, int n2) {
        while (true) {
            byte by;
            byte by2;
            if (n >= n2) {
                return 0;
            }
            if ((by2 = byArray[n++]) >= 0) continue;
            if (by2 < -32) {
                if (n >= n2) {
                    return by2;
                }
                if (by2 >= -62 && byArray[n++] <= -65) continue;
                return -1;
            }
            if (by2 < -16) {
                if (n >= n2 - 1) {
                    return Utf8.access$1100(byArray, n, n2);
                }
                if (!((by = byArray[n++]) > -65 || by2 == -32 && by < -96 || by2 == -19 && by >= -96) && byArray[n++] <= -65) continue;
                return -1;
            }
            if (n >= n2 - 2) {
                return Utf8.access$1100(byArray, n, n2);
            }
            if ((by = byArray[n++]) > -65 || (by2 << 28) + (by - -112) >> 30 != 0 || byArray[n++] > -65 || byArray[n++] > -65) break;
        }
        return -1;
    }
}

