/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import com.google.protobuf.Utf8$Processor;
import com.google.protobuf.Utf8$SafeProcessor;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.Utf8$UnsafeProcessor;
import java.nio.ByteBuffer;

final class Utf8 {
    private static final Utf8$Processor processor = Utf8$UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new Utf8$UnsafeProcessor() : new Utf8$SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    public static boolean isValidUtf8(byte[] byArray) {
        return processor.isValidUtf8(byArray, 0, byArray.length);
    }

    public static boolean isValidUtf8(byte[] byArray, int n, int n2) {
        return processor.isValidUtf8(byArray, n, n2);
    }

    public static int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
        return processor.partialIsValidUtf8(n, byArray, n2, n3);
    }

    private static int incompleteStateFor(int n) {
        return n > -12 ? -1 : n;
    }

    private static int incompleteStateFor(int n, int n2) {
        return n > -12 || n2 > -65 ? -1 : n ^ n2 << 8;
    }

    private static int incompleteStateFor(int n, int n2, int n3) {
        return n > -12 || n2 > -65 || n3 > -65 ? -1 : n ^ n2 << 8 ^ n3 << 16;
    }

    private static int incompleteStateFor(byte[] byArray, int n, int n2) {
        byte by = byArray[n - 1];
        switch (n2 - n) {
            case 0: {
                return Utf8.incompleteStateFor(by);
            }
            case 1: {
                return Utf8.incompleteStateFor(by, byArray[n]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by, (int)byArray[n], (int)byArray[n + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer byteBuffer, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return Utf8.incompleteStateFor(n);
            }
            case 1: {
                return Utf8.incompleteStateFor(n, byteBuffer.get(n2));
            }
            case 2: {
                return Utf8.incompleteStateFor(n, (int)byteBuffer.get(n2), (int)byteBuffer.get(n2 + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c2 = charSequence.charAt(n);
            if (c2 < '\u0800') {
                n3 += 127 - c2 >>> 31;
            } else {
                n3 += Utf8.encodedLengthGeneral(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0800') {
                n3 += 127 - c2 >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c2 || c2 > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new Utf8$UnpairedSurrogateException(i, n2);
            }
            ++i;
        }
        return n3;
    }

    static int encode(CharSequence charSequence, byte[] byArray, int n, int n2) {
        return processor.encodeUtf8(charSequence, byArray, n, n2);
    }

    static boolean isValidUtf8(ByteBuffer byteBuffer) {
        return processor.isValidUtf8(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    static int partialIsValidUtf8(int n, ByteBuffer byteBuffer, int n2, int n3) {
        return processor.partialIsValidUtf8(n, byteBuffer, n2, n3);
    }

    static String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) {
        return processor.decodeUtf8(byteBuffer, n, n2);
    }

    static String decodeUtf8(byte[] byArray, int n, int n2) {
        return processor.decodeUtf8(byArray, n, n2);
    }

    static void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        processor.encodeUtf8(charSequence, byteBuffer);
    }

    private static int estimateConsecutiveAscii(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        int n4 = n2 - 7;
        for (n3 = n; n3 < n4 && (byteBuffer.getLong(n3) & 0x8080808080808080L) == 0L; n3 += 8) {
        }
        return n3 - n;
    }

    private Utf8() {
    }

    static /* synthetic */ int access$000(int n, int n2) {
        return Utf8.incompleteStateFor(n, n2);
    }

    static /* synthetic */ int access$100(int n, int n2, int n3) {
        return Utf8.incompleteStateFor(n, n2, n3);
    }

    static /* synthetic */ int access$200(ByteBuffer byteBuffer, int n, int n2) {
        return Utf8.estimateConsecutiveAscii(byteBuffer, n, n2);
    }

    static /* synthetic */ int access$300(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return Utf8.incompleteStateFor(byteBuffer, n, n2, n3);
    }

    static /* synthetic */ int access$1100(byte[] byArray, int n, int n2) {
        return Utf8.incompleteStateFor(byArray, n, n2);
    }

    static /* synthetic */ int access$1200(int n) {
        return Utf8.incompleteStateFor(n);
    }
}

